/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.parser;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.util.io.InputStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.flowable.common.engine.impl.util.io.StringStreamSource;
import org.flowable.common.engine.impl.util.io.UrlStreamSource;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.io.ResourceStreamSource;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.xml.constants.DmnXMLConstants;
import org.flowable.dmn.xml.converter.DmnXMLConverter;
import org.flowable.dmn.xml.exception.DmnXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnParse
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnParse.class);
    protected String name;
    protected boolean validateSchema = true;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected DmnDefinition dmnDefinition;
    protected String targetNamespace;
    protected DmnDeploymentEntity deployment;
    protected List<DecisionEntity> decisions = new ArrayList<DecisionEntity>();

    public DmnParse deployment(DmnDeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public DmnParse execute(DmnEngineConfiguration dmnEngineConfig) {
        try {
            DmnXMLConverter converter = new DmnXMLConverter();
            boolean enableSafeDmnXml = dmnEngineConfig.isEnableSafeDmnXml();
            String encoding = dmnEngineConfig.getXmlEncoding();
            this.dmnDefinition = encoding != null ? converter.convertToDmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeDmnXml, encoding) : converter.convertToDmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeDmnXml);
            if (this.dmnDefinition != null && this.dmnDefinition.getDecisions() != null) {
                DecisionEntity decisionEntity;
                for (DecisionService decisionService : this.dmnDefinition.getDecisionServices()) {
                    decisionEntity = (DecisionEntity)CommandContextUtil.getDmnEngineConfiguration().getDecisionDataManager().create();
                    decisionEntity.setKey(decisionService.getId());
                    decisionEntity.setName(decisionService.getName());
                    decisionEntity.setResourceName(this.name);
                    decisionEntity.setDeploymentId(this.deployment.getId());
                    decisionEntity.setDescription(decisionService.getDescription());
                    decisionEntity.setDecisionType("decision_service");
                    this.decisions.add(decisionEntity);
                }
                if (this.dmnDefinition.getDecisionServices().isEmpty()) {
                    for (Decision decision : this.dmnDefinition.getDecisions()) {
                        decisionEntity = (DecisionEntity)CommandContextUtil.getDmnEngineConfiguration().getDecisionDataManager().create();
                        decisionEntity.setKey(decision.getId());
                        decisionEntity.setName(decision.getName());
                        decisionEntity.setResourceName(this.name);
                        decisionEntity.setDeploymentId(this.deployment.getId());
                        decisionEntity.setDescription(decision.getDescription());
                        decisionEntity.setDecisionType("decision_table");
                        this.decisions.add(decisionEntity);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            if (e instanceof DmnXMLException) {
                throw (DmnXMLException)e;
            }
            throw new FlowableException("Error parsing XML", (Throwable)e);
        }
        return this;
    }

    public DmnParse name(String name) {
        this.name = name;
        return this;
    }

    public DmnParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource((StreamSource)new InputStreamSource(inputStream));
        return this;
    }

    public DmnParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource((StreamSource)new UrlStreamSource(url));
        return this;
    }

    public DmnParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("malformed url: " + url, (Throwable)e);
        }
    }

    public DmnParse sourceResource(String resource) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource));
        return this;
    }

    public DmnParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource((StreamSource)new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new FlowableException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public DmnParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public List<DecisionEntity> getDecisions() {
        return this.decisions;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public DmnDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DmnDeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public DmnDefinition getDmnDefinition() {
        return this.dmnDefinition;
    }

    public void setDmnDefinition(DmnDefinition dmnDefinition) {
        this.dmnDefinition = dmnDefinition;
    }
}

