/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el.util;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.flowable.dmn.engine.impl.el.util.DMNParseUtil;
import org.springframework.util.CollectionUtils;

public class CollectionUtil {
    public static boolean allOf(Object collection, Object value) {
        if (collection == null) {
            throw new IllegalArgumentException("collection cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Collection targetCollection = CollectionUtil.getTargetCollection(collection, value);
        if (DMNParseUtil.isParseableCollection(value)) {
            Collection valueCollection = DMNParseUtil.parseCollection(value, targetCollection);
            return valueCollection != null && targetCollection.containsAll(valueCollection);
        }
        if (DMNParseUtil.isJavaCollection(value)) {
            return targetCollection.containsAll((Collection)value);
        }
        if (DMNParseUtil.isArrayNode(value)) {
            Collection valueCollection = DMNParseUtil.getCollectionFromArrayNode((ArrayNode)value);
            return valueCollection != null && targetCollection.containsAll(valueCollection);
        }
        Object formattedValue = DMNParseUtil.getFormattedValue(value, targetCollection);
        return targetCollection.contains(formattedValue);
    }

    @Deprecated
    public static boolean contains(Object collection, Object value) {
        return CollectionUtil.allOf(collection, value);
    }

    public static boolean noneOf(Object collection, Object value) {
        if (collection == null) {
            throw new IllegalArgumentException("collection cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Collection targetCollection = CollectionUtil.getTargetCollection(collection, value);
        if (DMNParseUtil.isParseableCollection(value)) {
            Collection valueCollection = DMNParseUtil.parseCollection(value, targetCollection);
            return !CollectionUtils.containsAny((Collection)targetCollection, (Collection)valueCollection);
        }
        if (DMNParseUtil.isJavaCollection(value)) {
            return !CollectionUtils.containsAny((Collection)targetCollection, (Collection)((Collection)value));
        }
        if (DMNParseUtil.isArrayNode(value)) {
            Collection valueCollection = DMNParseUtil.getCollectionFromArrayNode((ArrayNode)value);
            return !CollectionUtils.containsAny((Collection)targetCollection, (Collection)valueCollection);
        }
        Object formattedValue = DMNParseUtil.getFormattedValue(value, targetCollection);
        return !targetCollection.contains(formattedValue);
    }

    @Deprecated
    public static boolean notContains(Object collection, Object value) {
        return CollectionUtil.noneOf(collection, value);
    }

    public static boolean anyOf(Object collection, Object value) {
        if (collection == null) {
            throw new IllegalArgumentException("collection cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Collection targetCollection = CollectionUtil.getTargetCollection(collection, value);
        if (DMNParseUtil.isParseableCollection(value)) {
            Collection valueCollection = DMNParseUtil.parseCollection(value, targetCollection);
            return valueCollection != null && CollectionUtils.containsAny((Collection)targetCollection, (Collection)valueCollection);
        }
        if (DMNParseUtil.isJavaCollection(value)) {
            return CollectionUtils.containsAny((Collection)targetCollection, (Collection)((Collection)value));
        }
        if (DMNParseUtil.isArrayNode(value)) {
            Collection valueCollection = DMNParseUtil.getCollectionFromArrayNode((ArrayNode)value);
            return valueCollection != null && CollectionUtils.containsAny((Collection)targetCollection, (Collection)valueCollection);
        }
        Object formattedValue = DMNParseUtil.getFormattedValue(value, targetCollection);
        return targetCollection.contains(formattedValue);
    }

    @Deprecated
    public static boolean containsAny(Object collection, Object value) {
        return CollectionUtil.anyOf(collection, value);
    }

    public static boolean notAllOf(Object collection, Object value) {
        if (collection == null) {
            throw new IllegalArgumentException("collection cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Collection targetCollection = CollectionUtil.getTargetCollection(collection, value);
        if (DMNParseUtil.isParseableCollection(value)) {
            Collection valueCollection = DMNParseUtil.parseCollection(value, targetCollection);
            return valueCollection == null || !targetCollection.containsAll(valueCollection);
        }
        if (DMNParseUtil.isJavaCollection(value)) {
            return !targetCollection.containsAll((Collection)value);
        }
        if (DMNParseUtil.isArrayNode(value)) {
            Collection valueCollection = DMNParseUtil.getCollectionFromArrayNode((ArrayNode)value);
            return valueCollection == null || !targetCollection.containsAll(valueCollection);
        }
        Object formattedValue = DMNParseUtil.getFormattedValue(value, targetCollection);
        return !targetCollection.contains(formattedValue);
    }

    @Deprecated
    public static boolean notContainsAny(Object collection, Object value) {
        return CollectionUtil.notAllOf(collection, value);
    }

    protected static Collection getTargetCollection(Object collection, Object value) {
        Collection<Object> targetCollection = !DMNParseUtil.isCollection(collection) ? (DMNParseUtil.isParseableCollection(collection) ? DMNParseUtil.parseCollection(collection, value) : Arrays.asList(collection)) : (DMNParseUtil.isArrayNode(collection) ? DMNParseUtil.getCollectionFromArrayNode((ArrayNode)collection) : (List<Object>)collection);
        return targetCollection;
    }
}

