/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmnEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, DmnEngine> dmnEngines;
    protected static Map<String, EngineInfo> dmnEngineInfosByName;
    protected static Map<String, EngineInfo> dmnEngineInfosByResourceUrl;
    protected static List<EngineInfo> dmnEngineInfos;

    public static synchronized void init() {
        if (!DmnEngines.isInitialized()) {
            if (dmnEngines == null) {
                dmnEngines = new HashMap<String, DmnEngine>();
            }
            ClassLoader classLoader = DmnEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.dmn.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable.dmn.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                LOGGER.info("Initializing dmn engine using configuration '{}'", (Object)resource.toString());
                DmnEngines.initDmnEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-dmn-context.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable-dmn-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                LOGGER.info("Initializing dmn engine using Spring configuration '{}'", (Object)resource.toString());
                DmnEngines.initDmnEngineFromSpringResource(resource);
            }
            DmnEngines.setInitialized(true);
        } else {
            LOGGER.info("DMN engines already initialized");
        }
    }

    protected static void initDmnEngineFromSpringResource(URL resource) {
        try {
            Class springConfigurationHelperClass = ReflectUtil.loadClass((String)"org.flowable.dmn.spring.SpringDmnConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildDmnEngine", URL.class);
            DmnEngine dmnEngine = (DmnEngine)method.invoke(null, resource);
            String dmnEngineName = dmnEngine.getName();
            EngineInfo dmnEngineInfo = new EngineInfo(dmnEngineName, resource.toString(), null);
            dmnEngineInfosByName.put(dmnEngineName, dmnEngineInfo);
            dmnEngineInfosByResourceUrl.put(resource.toString(), dmnEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize dmn engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerDmnEngine(DmnEngine dmnEngine) {
        dmnEngines.put(dmnEngine.getName(), dmnEngine);
    }

    public static void unregister(DmnEngine dmnEngine) {
        dmnEngines.remove(dmnEngine.getName());
    }

    private static EngineInfo initDmnEngineFromResource(URL resourceUrl) {
        EngineInfo dmnEngineInfo = dmnEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (dmnEngineInfo != null) {
            dmnEngineInfos.remove(dmnEngineInfo);
            if (dmnEngineInfo.getException() == null) {
                String dmnEngineName = dmnEngineInfo.getName();
                dmnEngines.remove(dmnEngineName);
                dmnEngineInfosByName.remove(dmnEngineName);
            }
            dmnEngineInfosByResourceUrl.remove(dmnEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOGGER.info("initializing dmn engine for resource {}", (Object)resourceUrl);
            DmnEngine dmnEngine = DmnEngines.buildDmnEngine(resourceUrl);
            String dmnEngineName = dmnEngine.getName();
            LOGGER.info("initialised dmn engine {}", (Object)dmnEngineName);
            dmnEngineInfo = new EngineInfo(dmnEngineName, resourceUrlString, null);
            dmnEngines.put(dmnEngineName, dmnEngine);
            dmnEngineInfosByName.put(dmnEngineName, dmnEngineInfo);
        }
        catch (Throwable e) {
            LOGGER.error("Exception while initializing dmn engine: {}", (Object)e.getMessage(), (Object)e);
            dmnEngineInfo = new EngineInfo(null, resourceUrlString, ExceptionUtils.getStackTrace((Throwable)e));
        }
        dmnEngineInfosByResourceUrl.put(resourceUrlString, dmnEngineInfo);
        dmnEngineInfos.add(dmnEngineInfo);
        return dmnEngineInfo;
    }

    protected static DmnEngine buildDmnEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            DmnEngineConfiguration dmnEngineConfiguration = DmnEngineConfiguration.createDmnEngineConfigurationFromInputStream(inputStream);
            DmnEngine dmnEngine = dmnEngineConfiguration.buildDmnEngine();
            return dmnEngine;
        }
        catch (IOException e) {
            throw new FlowableException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static List<EngineInfo> getDmnEngineInfos() {
        return dmnEngineInfos;
    }

    public static EngineInfo getDmnEngineInfo(String dmnEngineName) {
        return dmnEngineInfosByName.get(dmnEngineName);
    }

    public static DmnEngine getDefaultDmnEngine() {
        return DmnEngines.getDmnEngine(NAME_DEFAULT);
    }

    public static DmnEngine getDmnEngine(String dmnEngineName) {
        if (!DmnEngines.isInitialized()) {
            DmnEngines.init();
        }
        return dmnEngines.get(dmnEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        LOGGER.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return DmnEngines.initDmnEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, DmnEngine> getDmnEngines() {
        return dmnEngines;
    }

    public static synchronized void destroy() {
        if (DmnEngines.isInitialized()) {
            HashMap<String, DmnEngine> engines = new HashMap<String, DmnEngine>(dmnEngines);
            dmnEngines = new HashMap<String, DmnEngine>();
            for (String dmnEngineName : engines.keySet()) {
                DmnEngine dmnEngine = (DmnEngine)engines.get(dmnEngineName);
                try {
                    dmnEngine.close();
                }
                catch (Exception e) {
                    LOGGER.error("exception while closing {}", (Object)(dmnEngineName == null ? "the default dmn engine" : "dmn engine " + dmnEngineName), (Object)e);
                }
            }
            dmnEngineInfosByName.clear();
            dmnEngineInfosByResourceUrl.clear();
            dmnEngineInfos.clear();
            DmnEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        DmnEngines.isInitialized = isInitialized;
    }

    static {
        dmnEngines = new HashMap<String, DmnEngine>();
        dmnEngineInfosByName = new HashMap<String, EngineInfo>();
        dmnEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        dmnEngineInfos = new ArrayList<EngineInfo>();
    }
}

