/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.model.BuiltinAggregator;
import org.flowable.dmn.model.HitPolicy;

public class HitPolicyCollect
extends AbstractHitPolicy
implements ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.COLLECT.getValue();
    }

    @Override
    public void composeDecisionResults(ELExecutionContext executionContext) {
        ArrayList<Object> decisionResults = new ArrayList();
        if (executionContext.getRuleResults() != null && !executionContext.getRuleResults().isEmpty()) {
            Map.Entry<String, List<Double>> distinctOutputValuesEntry;
            if (executionContext.getAggregator() == null) {
                decisionResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
            } else if (executionContext.getAggregator() == BuiltinAggregator.SUM) {
                Map.Entry<String, List<Double>> distinctOutputValuesEntry2 = this.createDistinctOutputDoubleValues(executionContext);
                if (distinctOutputValuesEntry2 != null) {
                    Double sumResult = this.aggregateSum(distinctOutputValuesEntry2.getValue());
                    decisionResults.add(this.createDecisionResults(distinctOutputValuesEntry2.getKey(), sumResult));
                }
            } else if (executionContext.getAggregator() == BuiltinAggregator.MIN) {
                Map.Entry<String, List<Double>> distinctOutputValuesEntry3 = this.createDistinctOutputDoubleValues(executionContext);
                if (distinctOutputValuesEntry3 != null) {
                    Double minResult = this.aggregateMin(distinctOutputValuesEntry3.getValue());
                    decisionResults.add(this.createDecisionResults(distinctOutputValuesEntry3.getKey(), minResult));
                }
            } else if (executionContext.getAggregator() == BuiltinAggregator.MAX) {
                Map.Entry<String, List<Double>> distinctOutputValuesEntry4 = this.createDistinctOutputDoubleValues(executionContext);
                if (distinctOutputValuesEntry4 != null) {
                    Double maxResult = this.aggregateMax(distinctOutputValuesEntry4.getValue());
                    decisionResults.add(this.createDecisionResults(distinctOutputValuesEntry4.getKey(), maxResult));
                }
            } else if (executionContext.getAggregator() == BuiltinAggregator.COUNT && (distinctOutputValuesEntry = this.createDistinctOutputDoubleValues(executionContext)) != null) {
                Double countResult = this.aggregateCount(distinctOutputValuesEntry.getValue());
                decisionResults.add(this.createDecisionResults(distinctOutputValuesEntry.getKey(), countResult));
            }
        }
        executionContext.getAuditContainer().setDecisionResult(decisionResults);
    }

    protected Map.Entry<String, List<Double>> createDistinctOutputDoubleValues(ELExecutionContext executionContext) {
        ArrayList<Map<String, Object>> ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        HashSet<Map<String, Object>> distinctRuleResults = new HashSet<Map<String, Object>>(ruleResults);
        HashMap distinctOutputDoubleValues = new HashMap();
        for (Map map : distinctRuleResults) {
            for (Map.Entry entry : map.entrySet()) {
                if (distinctOutputDoubleValues.containsKey(entry.getKey()) && distinctOutputDoubleValues.get(entry.getKey()) instanceof List) {
                    ((List)distinctOutputDoubleValues.get(entry.getKey())).add((Double)entry.getValue());
                    continue;
                }
                ArrayList<Double> valuesList = new ArrayList<Double>();
                valuesList.add((Double)entry.getValue());
                distinctOutputDoubleValues.put(entry.getKey(), valuesList);
            }
        }
        Map.Entry firstEntry = null;
        if (!distinctOutputDoubleValues.isEmpty()) {
            firstEntry = distinctOutputDoubleValues.entrySet().iterator().next();
        }
        return firstEntry;
    }

    protected Double aggregateSum(List<Double> values) {
        double aggregate = 0.0;
        for (Double value : values) {
            aggregate += value.doubleValue();
        }
        return aggregate;
    }

    protected Double aggregateMin(List<Double> values) {
        return Collections.min(values);
    }

    protected Double aggregateMax(List<Double> values) {
        return Collections.max(values);
    }

    protected Double aggregateCount(List<Double> values) {
        return values.size();
    }

    protected Map<String, Object> createDecisionResults(String outputName, Double outputValue) {
        HashMap<String, Object> ruleResult = new HashMap<String, Object>();
        ruleResult.put(outputName, outputValue);
        return ruleResult;
    }
}

