/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.OutputOrderComparator;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.engine.common.api.FlowableException;

public class HitPolicyPriority
extends AbstractHitPolicy
implements ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.PRIORITY.getValue();
    }

    @Override
    public void composeDecisionResults(final ELExecutionContext executionContext) {
        ArrayList<Map<String, Object>> ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        Collections.sort(ruleResults, new Comparator<Object>(){
            boolean noOutputValuesPresent = true;

            @Override
            public int compare(Object o1, Object o2) {
                CompareToBuilder compareToBuilder = new CompareToBuilder();
                for (Map.Entry<String, List<Object>> entry : executionContext.getOutputValues().entrySet()) {
                    List<Object> outputValues = entry.getValue();
                    if (outputValues == null && outputValues.isEmpty()) continue;
                    this.noOutputValuesPresent = false;
                    compareToBuilder.append(((Map)o1).get(entry.getKey()), ((Map)o2).get(entry.getKey()), (Comparator)new OutputOrderComparator(outputValues.toArray(new Comparable[outputValues.size()])));
                }
                if (!this.noOutputValuesPresent) {
                    return compareToBuilder.toComparison();
                }
                if (CommandContextUtil.getDmnEngineConfiguration().isStrictMode()) {
                    throw new FlowableException(String.format("HitPolicy: %s; no output values present", HitPolicyPriority.this.getHitPolicyName()));
                }
                return 0;
            }
        });
        executionContext.getAuditContainer().addDecisionResultObject((Map)ruleResults.get(0));
    }
}

