/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.query.Query;
import org.flowable.engine.common.api.query.QueryProperty;
import org.flowable.engine.common.impl.Direction;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.db.ListQueryParameterObject;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;

public abstract class AbstractQuery<T extends Query<?, ?>, U>
extends ListQueryParameterObject
implements Command<Object>,
Query<T, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient CommandExecutor commandExecutor;
    protected transient CommandContext commandContext;

    protected AbstractQuery() {
        this.parameter = this;
    }

    protected AbstractQuery(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public AbstractQuery(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public AbstractQuery<T, U> setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public T orderBy(QueryProperty property) {
        this.orderProperty = property;
        return (T)this;
    }

    public T orderBy(QueryProperty property, Query.NullHandlingOnOrder nullHandlingOnOrder) {
        this.orderBy(property);
        this.nullHandlingOnOrder = nullHandlingOnOrder;
        return (T)this;
    }

    public T asc() {
        return this.direction(Direction.ASCENDING);
    }

    public T desc() {
        return this.direction(Direction.DESCENDING);
    }

    public T direction(Direction direction) {
        if (this.orderProperty == null) {
            throw new FlowableIllegalArgumentException("You should call any of the orderBy methods first before specifying a direction");
        }
        this.addOrder(this.orderProperty.getName(), direction.getName(), this.nullHandlingOnOrder);
        this.orderProperty = null;
        this.nullHandlingOnOrder = null;
        return (T)this;
    }

    protected void checkQueryOk() {
        if (this.orderProperty != null) {
            throw new FlowableIllegalArgumentException("Invalid query: call asc() or desc() after using orderByXX()");
        }
    }

    public U singleResult() {
        this.resultType = ListQueryParameterObject.ResultType.SINGLE_RESULT;
        if (this.commandExecutor != null) {
            return (U)this.commandExecutor.execute((Command)this);
        }
        return this.executeSingleResult(Context.getCommandContext());
    }

    public List<U> list() {
        this.resultType = ListQueryParameterObject.ResultType.LIST;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute((Command)this);
        }
        return this.executeList(Context.getCommandContext());
    }

    public List<U> listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.resultType = ListQueryParameterObject.ResultType.LIST_PAGE;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute((Command)this);
        }
        return this.executeList(Context.getCommandContext());
    }

    public long count() {
        this.resultType = ListQueryParameterObject.ResultType.COUNT;
        if (this.commandExecutor != null) {
            return (Long)this.commandExecutor.execute((Command)this);
        }
        return this.executeCount(Context.getCommandContext());
    }

    public Object execute(CommandContext commandContext) {
        if (this.resultType == ListQueryParameterObject.ResultType.LIST) {
            return this.executeList(commandContext);
        }
        if (this.resultType == ListQueryParameterObject.ResultType.SINGLE_RESULT) {
            return this.executeSingleResult(commandContext);
        }
        if (this.resultType == ListQueryParameterObject.ResultType.LIST_PAGE) {
            return this.executeList(commandContext);
        }
        return this.executeCount(commandContext);
    }

    public abstract long executeCount(CommandContext var1);

    public abstract List<U> executeList(CommandContext var1);

    public U executeSingleResult(CommandContext commandContext) {
        List<U> results = this.executeList(commandContext);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("Query return " + results.size() + " results instead of max 1");
        }
        return null;
    }
}

