/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.configurator;

import java.util.ArrayList;
import java.util.List;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.deployer.DmnDeployer;
import org.flowable.dmn.engine.impl.cfg.StandaloneInMemDmnEngineConfiguration;
import org.flowable.dmn.engine.impl.db.EntityDependencyOrder;
import org.flowable.engine.cfg.AbstractEngineConfigurator;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.Deployer;

public class DmnEngineConfigurator
extends AbstractEngineConfigurator {
    protected DmnEngineConfiguration dmnEngineConfiguration;

    public int getPriority() {
        return 200000;
    }

    protected List<Deployer> getCustomDeployers() {
        ArrayList<Deployer> deployers = new ArrayList<Deployer>();
        deployers.add(new DmnDeployer());
        return deployers;
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/dmn/db/mapping/mappings.xml";
    }

    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.dmnEngineConfiguration == null) {
            this.dmnEngineConfiguration = new StandaloneInMemDmnEngineConfiguration();
        }
        this.initialiseCommonProperties(processEngineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
        this.initDmnEngine();
        this.initServiceConfigurations(processEngineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    protected synchronized DmnEngine initDmnEngine() {
        if (this.dmnEngineConfiguration == null) {
            throw new FlowableException("DmnEngineConfiguration is required");
        }
        return this.dmnEngineConfiguration.buildDmnEngine();
    }

    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }

    public DmnEngineConfigurator setDmnEngineConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        return this;
    }
}

