/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.constants.CmmnStencilConstants;
import org.flowable.cmmn.editor.constants.EditorJsonConstants;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnJsonConverterUtil
implements EditorJsonConstants,
CmmnStencilConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnJsonConverterUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectNode createChildShape(String id, String type, double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode shapeNode = objectMapper.createObjectNode();
        shapeNode.set("bounds", (JsonNode)CmmnJsonConverterUtil.createBoundsNode(lowerRightX, lowerRightY, upperLeftX, upperLeftY));
        shapeNode.put("resourceId", id);
        ArrayNode shapesArrayNode = objectMapper.createArrayNode();
        shapeNode.set("childShapes", (JsonNode)shapesArrayNode);
        ObjectNode stencilNode = objectMapper.createObjectNode();
        stencilNode.put("id", type);
        shapeNode.set("stencil", (JsonNode)stencilNode);
        return shapeNode;
    }

    public static ObjectNode createBoundsNode(double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode boundsNode = objectMapper.createObjectNode();
        boundsNode.set("lowerRight", (JsonNode)CmmnJsonConverterUtil.createPositionNode(lowerRightX, lowerRightY));
        boundsNode.set("upperLeft", (JsonNode)CmmnJsonConverterUtil.createPositionNode(upperLeftX, upperLeftY));
        return boundsNode;
    }

    public static ObjectNode createPositionNode(double x, double y) {
        ObjectNode positionNode = objectMapper.createObjectNode();
        positionNode.put("x", x);
        positionNode.put("y", y);
        return positionNode;
    }

    public static ObjectNode createResourceNode(String id) {
        ObjectNode resourceNode = objectMapper.createObjectNode();
        resourceNode.put("resourceId", id);
        return resourceNode;
    }

    public static String getStencilId(JsonNode objectNode) {
        String stencilId = null;
        JsonNode stencilNode = objectNode.get("stencil");
        if (stencilNode != null && stencilNode.get("id") != null) {
            stencilId = stencilNode.get("id").asText();
        }
        return stencilId;
    }

    public static String getElementId(JsonNode objectNode) {
        String elementId = null;
        elementId = StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode)) ? CmmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode).trim() : objectNode.get("resourceId").asText();
        return elementId;
    }

    public static String getShapeId(JsonNode objectNode) {
        return objectNode.get("resourceId").asText();
    }

    public static String lookForSourceRef(String flowId, JsonNode childShapesNode) {
        String sourceRef = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                JsonNode outgoingNode = childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !flowId.equals(resourceNode.asText())) continue;
                        sourceRef = CmmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (sourceRef != null) break;
                }
                if ((sourceRef = CmmnJsonConverterUtil.lookForSourceRef(flowId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return sourceRef;
    }

    public static JsonNode validateIfNodeIsTextual(JsonNode node) {
        if (node != null && !node.isNull() && node.isTextual() && StringUtils.isNotEmpty((CharSequence)node.asText())) {
            try {
                node = CmmnJsonConverterUtil.validateIfNodeIsTextual(objectMapper.readTree(node.asText()));
            }
            catch (Exception e) {
                LOGGER.error("Error converting textual node", (Throwable)e);
            }
        }
        return node;
    }

    public static String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = CmmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !propertyNode.isNull() && !"null".equalsIgnoreCase(propertyNode.asText())) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static Integer getPropertyValueAsInteger(String name, JsonNode jsonNode) {
        Integer propertyValue = null;
        JsonNode propertyNode = CmmnJsonConverterUtil.getProperty(name, jsonNode);
        if (propertyNode != null && !propertyNode.isNull() && !"null".equalsIgnoreCase(propertyNode.asText()) && StringUtils.isNotEmpty((CharSequence)propertyNode.asText())) {
            propertyValue = propertyNode.asInt();
        }
        return propertyValue;
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return CmmnJsonConverterUtil.getPropertyValueAsBoolean(name, objectNode, false);
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode, boolean defaultValue) {
        boolean result = defaultValue;
        String stringValue = CmmnJsonConverterUtil.getPropertyValueAsString(name, objectNode);
        if ("Yes".equalsIgnoreCase(stringValue) || "true".equalsIgnoreCase(stringValue)) {
            result = true;
        } else if ("No".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
            result = false;
        }
        return result;
    }

    public static List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode propertyNode = CmmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            String[] valueList;
            String propertyValue = propertyNode.asText();
            for (String value : valueList = propertyValue.split(",")) {
                resultList.add(value.trim());
            }
        }
        return resultList;
    }

    public static String getPropertyFormKey(JsonNode elementNode, CmmnJsonConverterContext converterContext) {
        String formKey = CmmnJsonConverterUtil.getPropertyValueAsString("formkeydefinition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            return formKey;
        }
        JsonNode formReferenceNode = CmmnJsonConverterUtil.getProperty("formreference", elementNode);
        if (formReferenceNode != null && formReferenceNode.get("id") != null) {
            String formModelId = formReferenceNode.get("id").asText();
            formKey = converterContext.getFormModelKeyForFormModelId(formModelId);
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                return formKey;
            }
            formKey = formReferenceNode.path("key").asText();
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                return formKey;
            }
        }
        return null;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }
}

