/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.Map;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceUtil;
import org.flowable.cmmn.engine.impl.variable.CmmnAggregation;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.VariableAggregationDefinition;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CreatePlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public CreatePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    protected void internalExecute() {
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(this.planItemInstanceEntity);
        if (repetitionRule != null) {
            int repetitionCounter = PlanItemInstanceUtil.getRepetitionCounter(this.planItemInstanceEntity);
            if (repetitionCounter == 0 && repetitionRule.getAggregations() != null) {
                Map<String, VariableAggregationDefinition> aggregationsByTarget = CmmnAggregation.groupAggregationsByTarget(this.planItemInstanceEntity, repetitionRule.getAggregations().getOverviewAggregations(), CommandContextUtil.getCmmnEngineConfiguration(this.commandContext));
                for (String variableName : aggregationsByTarget.keySet()) {
                    CmmnAggregation bpmnAggregation = new CmmnAggregation(this.planItemInstanceEntity.getId());
                    this.planItemInstanceEntity.getParentVariableScope().setVariable(variableName, (Object)bpmnAggregation);
                }
            }
            if (repetitionRule.getAggregations() != null || !PlanItemInstanceUtil.hasIgnoreCounterVariable(this.planItemInstanceEntity)) {
                this.setRepetitionCounter(this.planItemInstanceEntity, repetitionCounter + 1);
            }
        }
        CmmnHistoryManager cmmnHistoryManager = CommandContextUtil.getCmmnHistoryManager(this.commandContext);
        cmmnHistoryManager.recordPlanItemInstanceCreated(this.planItemInstanceEntity);
        if (this.getNewState().equals("available")) {
            this.planItemInstanceEntity.setLastAvailableTime(this.getCurrentTime(this.commandContext));
            cmmnHistoryManager.recordPlanItemInstanceAvailable(this.planItemInstanceEntity);
        }
    }

    @Override
    public String getNewState() {
        if (this.isEventListenerWithAvailableCondition(this.planItemInstanceEntity.getPlanItem())) {
            return "unavailable";
        }
        return "available";
    }

    @Override
    public String getLifeCycleTransition() {
        return "create";
    }

    @Override
    public String getOperationName() {
        return "[Create plan item]";
    }
}

