/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.util;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.ScriptInfo;

public class ListenerXmlConverterUtil {
    public static FlowableListener convertToListener(XMLStreamReader xtr) throws Exception {
        FlowableListener listener = new FlowableListener();
        CmmnXmlUtil.addXMLLocation((BaseElement)listener, xtr);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "class"))) {
            listener.setImplementation(xtr.getAttributeValue(null, "class"));
            listener.setImplementationType("class");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "expression"))) {
            listener.setImplementation(xtr.getAttributeValue(null, "expression"));
            listener.setImplementationType("expression");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "delegateExpression"))) {
            listener.setImplementation(xtr.getAttributeValue(null, "delegateExpression"));
            listener.setImplementationType("delegateExpression");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "type"))) {
            listener.setImplementationType(xtr.getAttributeValue(null, "type"));
        }
        listener.setEvent(xtr.getAttributeValue(null, "event"));
        listener.setSourceState(xtr.getAttributeValue(null, "sourceState"));
        listener.setTargetState(xtr.getAttributeValue(null, "targetState"));
        listener.setOnTransaction(xtr.getAttributeValue(null, "onTransaction"));
        if ("script".equals(listener.getImplementationType())) {
            listener.setScriptInfo(ListenerXmlConverterUtil.parseScriptInfo(xtr));
        }
        return listener;
    }

    public static ScriptInfo parseScriptInfo(XMLStreamReader xtr) throws Exception {
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if (!xtr.getLocalName().equals("script")) continue;
                return ListenerXmlConverterUtil.createScriptInfo(xtr);
            }
            if (!xtr.isEndElement() || !"script".equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
        return null;
    }

    protected static ScriptInfo createScriptInfo(XMLStreamReader xtr) throws Exception {
        String elementText;
        ScriptInfo script = new ScriptInfo();
        CmmnXmlUtil.addXMLLocation((BaseElement)script, xtr);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "language"))) {
            script.setLanguage(xtr.getAttributeValue(null, "language"));
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "resultVariable"))) {
            script.setResultVariable(xtr.getAttributeValue(null, "resultVariable"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(elementText = xtr.getElementText()))) {
            script.setScript(elementText);
        }
        return script;
    }
}

