/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class NeedsAppDefinitionCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String appDefinitionId;

    public NeedsAppDefinitionCmd(String appDefinitionId) {
        this.appDefinitionId = appDefinitionId;
    }

    public T execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        AppDefinition appDefinition = CommandContextUtil.getAppRepositoryService().getAppDefinition(this.appDefinitionId);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find app definition with id " + this.appDefinitionId, AppDefinition.class);
        }
        return this.execute(commandContext, appDefinition);
    }

    protected abstract T execute(CommandContext var1, AppDefinition var2);
}

