/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.utils;

import java.lang.reflect.Field;
import java.security.Security;
import java.util.Arrays;
import java.util.List;

public class SystemInformation {
    public static final InformationProperty JAVA_VERSION;
    public static final InformationProperty OS_NAME;
    public static final InformationProperty OS_ARCH;
    public static final InformationProperty OS_VERSION;
    public static final InformationProperty VENDOR_NAME;
    public static final InformationProperty VENDOR_URL;
    public static final InformationProperty JVM_VERSION;
    public static final InformationProperty JVM_NAME;
    public static final InformationProperty JVM_VENDOR;
    public static final InformationProperty JAVA_LIB_PATH;
    public static final InformationProperty JDK_DISABLED_NAMED_CURVES;
    public static final InformationProperty JDK_DISABLE_NATIVE_OPTION;
    private static String systemInformation;
    public static List<String> EXPECTED_CURVES;

    public static String getSystemInformation() {
        return systemInformation;
    }

    static {
        Field[] fields;
        JAVA_VERSION = new InformationProperty("Java Version", System.getProperty("java.version"));
        OS_NAME = new InformationProperty("OS Name", System.getProperty("os.name"));
        OS_ARCH = new InformationProperty("OS Arch", System.getProperty("os.arch"));
        OS_VERSION = new InformationProperty("OS Version", System.getProperty("os.version"));
        VENDOR_NAME = new InformationProperty("Vendor Name", System.getProperty("java.vendor"));
        VENDOR_URL = new InformationProperty("Vendor URL", System.getProperty("java.vendor.url"));
        JVM_VERSION = new InformationProperty("JVM Version", System.getProperty("java.vm.version"));
        JVM_NAME = new InformationProperty("JVM Name", System.getProperty("java.vm.name"));
        JVM_VENDOR = new InformationProperty("JVM Vendor", System.getProperty("java.vm.vendor"));
        JAVA_LIB_PATH = new InformationProperty("JAVA Library Path", System.getProperty("java.library.path"));
        JDK_DISABLED_NAMED_CURVES = new InformationProperty("JDK Disabled NamedCurves", System.getProperty("jdk.disabled.namedCurves"));
        JDK_DISABLE_NATIVE_OPTION = new InformationProperty("JDK DisableNative Option", System.getProperty("jdk.sunec.disableNative"));
        EXPECTED_CURVES = Arrays.asList("secp256k1", "secp256r1");
        systemInformation = "[System Information]:\n";
        for (Field field : fields = SystemInformation.class.getDeclaredFields()) {
            if (!field.getType().equals(InformationProperty.class)) continue;
            try {
                InformationProperty property = (InformationProperty)field.get(null);
                systemInformation = systemInformation + "[" + property.getKey() + "] : " + property.getValue() + "\n";
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        String supportedCurves = Security.getProviders("AlgorithmParameters.EC")[0].getService("AlgorithmParameters", "EC").getAttribute("SupportedCurves");
        for (String curve : EXPECTED_CURVES) {
            if (supportedCurves.contains(curve)) {
                systemInformation = systemInformation + "[Support " + curve + "] : true\n";
                continue;
            }
            systemInformation = systemInformation + "[Support " + curve + "] : false\n";
        }
    }

    public static class InformationProperty {
        private String key;
        private String value;

        public InformationProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

