/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.sdk.v3.transaction.model.exception.JsonException;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    protected static Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

    private JsonUtils() {
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return JsonUtils.fromJsonWithException(json, clazz);
        }
        catch (Exception e) {
            log.error("json is: " + json, (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> c, Class ... t) {
        try {
            return JsonUtils.fromJsonWithException(json, c, t);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static <T> T fromJson(String json, JavaType type) {
        try {
            return JsonUtils.fromJsonWithException(json, type);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            log.error("json is: {}, e:", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T fromJsonWithException(String json, Class<T> clazz) throws JsonProcessingException {
        return (T)objectMapper.readValue(json, clazz);
    }

    public static <T> T fromJsonWithException(String json, Class<T> c, Class ... t) throws IOException {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(c, t);
        return (T)objectMapper.readValue(json, javaType);
    }

    public static <T> T fromJsonWithException(String json, JavaType type) throws JsonProcessingException {
        return (T)objectMapper.readValue(json, type);
    }

    public static <T> List<T> fromJsonList(String json, Class<T> c) {
        try {
            return JsonUtils.fromJsonListWithException(json, c);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static <T> List<T> fromJsonListWithException(String json, Class<T> c) throws IOException {
        JavaType type = JsonUtils.getCollectionType(ArrayList.class, c);
        return (List)objectMapper.readValue(json, type);
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static String toJsonWithException(Object o) throws JsonProcessingException {
        return objectMapper.writeValueAsString(o);
    }

    public static String toJson(Object o) {
        try {
            return JsonUtils.toJsonWithException(o);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public static <T, K> Map<T, K> convertValue(Object req, Class<T> keyClazz, Class<K> valueClazz) {
        return (Map)objectMapper.convertValue(req, (JavaType)objectMapper.getTypeFactory().constructMapType(Map.class, keyClazz, valueClazz));
    }

    public static <T> T convertMap(Map map, Class<T> retClazz) {
        return (T)objectMapper.convertValue((Object)map, retClazz);
    }
}

