/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.signer;

import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.v3.transaction.signer.AsyncTransactionSignercInterface;
import org.fisco.bcos.sdk.v3.transaction.signer.RemoteSignCallbackInterface;
import org.fisco.bcos.sdk.v3.transaction.signer.RemoteSignProviderInterface;
import org.fisco.bcos.sdk.v3.transaction.signer.TransactionSignerInterface;

public class TransactionSignerWithRemoteSignService
implements TransactionSignerInterface,
AsyncTransactionSignercInterface {
    private final RemoteSignProviderInterface transactionSignProvider;
    private final int encryptType;

    public TransactionSignerWithRemoteSignService(RemoteSignProviderInterface transactionSignProvider, int encryptType) {
        this.transactionSignProvider = transactionSignProvider;
        this.encryptType = encryptType;
    }

    @Override
    public SignatureResult sign(String rawTxHash, CryptoKeyPair cryptoKeyPair) {
        return this.sign(rawTxHash.getBytes(), cryptoKeyPair);
    }

    @Override
    public SignatureResult sign(byte[] rawTxHash, CryptoKeyPair cryptoKeyPair) {
        return this.transactionSignProvider.requestForSign(rawTxHash, this.encryptType);
    }

    @Override
    public void signAsync(byte[] dataToSign, RemoteSignCallbackInterface transactionSignCallback) {
        this.transactionSignProvider.requestForSignAsync(dataToSign, this.encryptType, transactionSignCallback);
    }
}

