/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.signer;

import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.crypto.signature.ECDSASignatureResult;
import org.fisco.bcos.sdk.v3.crypto.signature.SM2SignatureResult;
import org.fisco.bcos.sdk.v3.crypto.signature.Signature;
import org.fisco.bcos.sdk.v3.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.v3.transaction.signer.TransactionSignerInterface;

public class TransactionSignerService
implements TransactionSignerInterface {
    private Signature signature;

    public TransactionSignerService(Signature signature) {
        this.signature = signature;
    }

    @Override
    public SignatureResult sign(String hash, CryptoKeyPair cryptoKeyPair) {
        return this.signature.sign(hash, cryptoKeyPair);
    }

    @Override
    public SignatureResult sign(byte[] hash, CryptoKeyPair cryptoKeyPair) {
        return this.signature.sign(hash, cryptoKeyPair);
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public static SignatureResult decodeSignatureString(String signatureStr, int cryptoType, String publicKey) {
        SignatureResult signature;
        if (cryptoType == 0) {
            signature = new ECDSASignatureResult(signatureStr);
        } else if (cryptoType == 1) {
            signature = new SM2SignatureResult(publicKey, signatureStr);
        } else {
            throw new IllegalStateException("Error cryptoType: " + cryptoType);
        }
        return signature;
    }
}

