/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.pusher;

import java.util.concurrent.CompletableFuture;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.client.protocol.request.Transaction;
import org.fisco.bcos.sdk.v3.client.protocol.response.Call;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.v3.transaction.pusher.TransactionPusherInterface;

public class TransactionPusherService
implements TransactionPusherInterface {
    private Client client;

    public TransactionPusherService(Client client) {
        this.client = client;
    }

    @Override
    public void pushOnly(String signedTransaction) {
        this.client.sendTransactionAsync(signedTransaction, false, null);
    }

    @Override
    public Call push(String from, String to, byte[] encodedFunction) {
        Transaction transaction = new Transaction(from, to, encodedFunction);
        return this.client.call(transaction);
    }

    @Override
    public TransactionReceipt push(String signedTransaction) {
        return this.client.sendTransaction(signedTransaction, false).getTransactionReceipt();
    }

    @Override
    public void pushAsync(String signedTransactionData, TransactionCallback callback) {
        this.client.sendTransactionAsync(signedTransactionData, false, callback);
    }

    @Override
    public CompletableFuture<TransactionReceipt> pushAsync(String signedTransaction) {
        return CompletableFuture.supplyAsync(() -> this.push(signedTransaction));
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

