/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIObject;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.transaction.model.dto.CommonResponse;
import org.fisco.bcos.sdk.v3.transaction.tools.JsonUtils;

public class TransactionResponse
extends CommonResponse {
    private TransactionReceipt transactionReceipt;
    private String contractAddress;
    private String values;
    private String events;
    private String receiptMessages;
    private List<Object> returnObject;
    private List<ABIObject> returnABIObject;
    private List<Type> results;

    public TransactionResponse() {
    }

    public TransactionResponse(int returnCode, String returnMessage) {
        super(returnCode, returnMessage);
    }

    public TransactionResponse(TransactionReceipt tr, int returnCode, String returnMessage) {
        super(returnCode, returnMessage);
        this.transactionReceipt = tr;
    }

    public TransactionReceipt getTransactionReceipt() {
        return this.transactionReceipt;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getValues() {
        return this.values;
    }

    public List<Object> getValuesList() {
        if (StringUtils.isEmpty((CharSequence)this.values)) {
            return null;
        }
        return JsonUtils.fromJson(this.values, new TypeReference<List<Object>>(){});
    }

    public void setValues(String values) {
        this.values = values;
    }

    public String getEvents() {
        return this.events;
    }

    @JsonIgnore
    public Map<String, List<List<Object>>> getEventResultMap() {
        if (StringUtils.isEmpty((CharSequence)this.events)) {
            return null;
        }
        return JsonUtils.fromJson(this.events, new TypeReference<Map<String, List<List<Object>>>>(){});
    }

    public void setEvents(String events) {
        this.events = events;
    }

    public String getReceiptMessages() {
        return this.receiptMessages;
    }

    public void setReceiptMessages(String receiptMessages) {
        this.receiptMessages = receiptMessages;
    }

    public List<Object> getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(List<Object> returnObject) {
        this.returnObject = returnObject;
    }

    public List<ABIObject> getReturnABIObject() {
        return this.returnABIObject;
    }

    public void setReturnABIObject(List<ABIObject> returnABIObject) {
        this.returnABIObject = returnABIObject;
    }

    public void setResults(List<Type> results) {
        this.results = results;
    }

    public List<Type> getResults() {
        return this.results;
    }
}

