/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.codec.decode;

import java.math.BigInteger;
import java.util.function.Function;
import org.fisco.bcos.sdk.v3.client.protocol.response.Call;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.v3.model.PrecompiledRetCode;
import org.fisco.bcos.sdk.v3.model.RetCode;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.TransactionReceiptStatus;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.RevertMessageParser;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;

public class ReceiptParser {
    private ReceiptParser() {
    }

    public static RetCode parseTransactionReceipt(TransactionReceipt receipt, Function<TransactionReceipt, BigInteger> resultCaller) throws ContractException {
        int status = receipt.getStatus();
        if (status == 0) {
            RetCode precompiledRetCode = PrecompiledRetCode.CODE_SUCCESS;
            if (receipt.getOutput().equals("0x") || resultCaller == null) {
                return precompiledRetCode;
            }
            BigInteger apply = resultCaller.apply(receipt);
            precompiledRetCode = PrecompiledRetCode.getPrecompiledResponse(apply.intValue(), receipt.getMessage());
            precompiledRetCode.setTransactionReceipt(receipt);
            return precompiledRetCode;
        }
        ReceiptParser.getErrorStatus(receipt);
        return PrecompiledRetCode.CODE_SUCCESS;
    }

    public static void getErrorStatus(TransactionReceipt receipt) throws ContractException {
        RetCode retCode = TransactionReceiptStatus.getStatusMessage(receipt.getStatus(), receipt.getMessage());
        Tuple2<Boolean, String> errorOutput = RevertMessageParser.tryResolveRevertMessage(receipt);
        if (errorOutput.getValue1().booleanValue()) {
            throw new ContractException(errorOutput.getValue2(), retCode.getCode(), receipt);
        }
        throw new ContractException(retCode.getMessage(), retCode.getCode(), receipt);
    }

    public static ContractException parseExceptionCall(ContractException exception) {
        Call.CallOutput callResult = exception.getResponseOutput();
        if (callResult == null) {
            return exception;
        }
        RetCode retCode = ReceiptParser.parseCallOutput(callResult, exception.getMessage());
        return new ContractException(retCode.getMessage(), retCode.getCode());
    }

    public static RetCode parseCallOutput(Call.CallOutput callResult, String message) {
        if (callResult.getStatus() != 0) {
            Tuple2<Boolean, String> errorOutput = RevertMessageParser.tryResolveRevertMessage(callResult.getStatus(), callResult.getOutput());
            if (errorOutput.getValue1().booleanValue()) {
                return new RetCode(callResult.getStatus(), errorOutput.getValue2());
            }
            return TransactionReceiptStatus.getStatusMessage(callResult.getStatus(), message);
        }
        return PrecompiledRetCode.CODE_SUCCESS;
    }
}

