/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.model.callback;

import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.TransactionReceiptStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionCallback {
    private static final Logger logger = LoggerFactory.getLogger(TransactionCallback.class);
    public static final Integer DEFAULT_TRANS_TIMEOUT = 30000;
    private Integer timeout = DEFAULT_TRANS_TIMEOUT;

    public abstract void onResponse(TransactionReceipt var1);

    public void onError(int errorCode, String errorMessage) {
        logger.error("transaction exception, errorCode: {}, errorMessage: {}", (Object)errorCode, (Object)errorMessage);
        TransactionReceipt receipt = new TransactionReceipt();
        receipt.setStatus(errorCode);
        receipt.setMessage(errorMessage);
        this.onResponse(receipt);
    }

    public void onTimeout() {
        logger.warn("transactionSuc timeout");
        TransactionReceipt receipt = new TransactionReceipt();
        receipt.setStatus(TransactionReceiptStatus.TimeOut.getCode());
        receipt.setMessage(TransactionReceiptStatus.TimeOut.getMessage());
        this.onResponse(receipt);
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }
}

