/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.fisco.bcos.sdk.v3.model.RetCode;

public class TransactionReceiptStatus {
    public static final RetCode Success;
    public static final RetCode Unknown;
    public static final RetCode BadRLP;
    public static final RetCode NotEnoughCash;
    public static final RetCode BadInstruction;
    public static final RetCode BadJumpDestination;
    public static final RetCode OutOfGas;
    public static final RetCode OutOfStack;
    public static final RetCode StackUnderflow;
    public static final RetCode PrecompiledError;
    public static final RetCode RevertInstruction;
    public static final RetCode ContractAddressAlreadyUsed;
    public static final RetCode PermissionDenied;
    public static final RetCode CallAddressError;
    public static final RetCode GasOverflow;
    public static final RetCode ContractFrozen;
    public static final RetCode AccountFrozen;
    public static final RetCode WASMValidationFailure;
    public static final RetCode WASMArgumentOutOfRange;
    public static final RetCode WASMUnreachableInstruction;
    public static final RetCode WASMTrap;
    public static final RetCode NonceCheckFail;
    public static final RetCode BlockLimitCheckFail;
    public static final RetCode TxPoolIsFull;
    public static final RetCode Malform;
    public static final RetCode AlreadyInTxPool;
    public static final RetCode TxAlreadyInChain;
    public static final RetCode InvalidChainId;
    public static final RetCode InvalidGroupId;
    public static final RetCode InvalidSignature;
    public static final RetCode RequestNotBelongToTheGroup;
    public static final RetCode TimeOut;
    protected static Map<Integer, RetCode> codeToRetCode;

    public static RetCode getStatusMessage(Integer status, String message) {
        if (codeToRetCode.containsKey(status)) {
            return codeToRetCode.get(status);
        }
        return new RetCode(status, message);
    }

    static {
        Field[] fields;
        Success = new RetCode(0, "Success");
        Unknown = new RetCode(1, "Unknown");
        BadRLP = new RetCode(2, "OutOfGasLimit");
        NotEnoughCash = new RetCode(7, "Not enough cash");
        BadInstruction = new RetCode(10, "Bad instruction");
        BadJumpDestination = new RetCode(11, "Bad jump destination");
        OutOfGas = new RetCode(12, "Out-of-gas during VM execution");
        OutOfStack = new RetCode(13, "Out of stack");
        StackUnderflow = new RetCode(14, "Stack underflow");
        PrecompiledError = new RetCode(15, "Precompiled error");
        RevertInstruction = new RetCode(16, "Revert instruction");
        ContractAddressAlreadyUsed = new RetCode(17, "ContractAddressAlreadyUsed");
        PermissionDenied = new RetCode(18, "Permission denied");
        CallAddressError = new RetCode(19, "Call address error");
        GasOverflow = new RetCode(20, "GasOverflow");
        ContractFrozen = new RetCode(21, "ContractFrozen");
        AccountFrozen = new RetCode(22, "AccountFrozen");
        WASMValidationFailure = new RetCode(32, "WASMValidationFailure, check the bin file is valid");
        WASMArgumentOutOfRange = new RetCode(33, "WASMArgumentOutOfRange");
        WASMUnreachableInstruction = new RetCode(34, "WASMUnreachableInstruction");
        WASMTrap = new RetCode(35, "WASMTrap");
        NonceCheckFail = new RetCode(1000, "NonceCheckFail");
        BlockLimitCheckFail = new RetCode(1001, "BlockLimitCheckFail");
        TxPoolIsFull = new RetCode(1002, "TxPoolIsFull");
        Malform = new RetCode(1003, "Malform tx");
        AlreadyInTxPool = new RetCode(1004, "AlreadyInTxPool");
        TxAlreadyInChain = new RetCode(1005, "TxAlreadyInChain");
        InvalidChainId = new RetCode(1006, "InvalidChainId");
        InvalidGroupId = new RetCode(1007, "InvalidGroupId");
        InvalidSignature = new RetCode(1008, "InvalidSignature");
        RequestNotBelongToTheGroup = new RetCode(1009, "RequestNotBelongToTheGroup");
        TimeOut = new RetCode(50001, "Transaction receipt timeout");
        codeToRetCode = new HashMap<Integer, RetCode>();
        for (Field field : fields = TransactionReceiptStatus.class.getDeclaredFields()) {
            if (!field.getType().equals(RetCode.class)) continue;
            try {
                RetCode constantRetCode = (RetCode)field.get(null);
                codeToRetCode.put(constantRetCode.getCode(), constantRetCode);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

