/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.eventsub;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import org.fisco.bcos.sdk.jni.BcosSDKJniObj;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.jni.event.EventSubJniObj;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.config.ConfigOption;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.eventsub.EventSubCallback;
import org.fisco.bcos.sdk.v3.eventsub.EventSubParams;
import org.fisco.bcos.sdk.v3.eventsub.EventSubResponse;
import org.fisco.bcos.sdk.v3.eventsub.EventSubStatus;
import org.fisco.bcos.sdk.v3.eventsub.EventSubscribe;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscribeImp
implements EventSubscribe {
    private static final Logger logger = LoggerFactory.getLogger(EventSubscribeImp.class);
    private String groupId;
    private ConfigOption configOption;
    private CryptoSuite cryptoSuite;
    private EventSubJniObj eventSubJniObj;
    private final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

    public EventSubscribeImp(Client client, ConfigOption configOption) throws JniException {
        this.groupId = client.getGroup();
        this.configOption = configOption;
        this.cryptoSuite = client.getCryptoSuite();
        this.eventSubJniObj = EventSubJniObj.build((long)client.getNativePointer());
        this.configOption = client.getConfigOption();
        logger.info(" EventSub constructor, group: {}, configOption: {}", (Object)this.groupId, (Object)configOption);
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ConfigOption getConfigOption() {
        return this.configOption;
    }

    public void setConfigOption(ConfigOption configOption) {
        this.configOption = configOption;
    }

    @Override
    public String subscribeEvent(EventSubParams params, EventSubCallback callback) {
        if (!params.checkParams()) {
            callback.onReceiveLog("", EventSubStatus.INVALID_PARAMS.getStatus(), null);
            return "";
        }
        String strParams = null;
        try {
            strParams = this.objectMapper.writeValueAsString((Object)params);
        }
        catch (JsonProcessingException e) {
            logger.error("e: ", (Throwable)e);
            return "";
        }
        logger.info("EventSub subscribeEvent, params: {}", (Object)params);
        return this.eventSubJniObj.subscribeEvent(this.groupId, strParams, response -> {
            if (response.getErrorCode() != 0) {
                logger.error("subscribeEvent response error, errorCode: {}, errorMessage: {}", (Object)response.getErrorCode(), (Object)response.getErrorMessage());
                callback.onReceiveLog("", response.getErrorCode(), null);
                return;
            }
            String strResp = new String(response.getData());
            logger.debug("subscribeEvent response, errorCode: {}, errorMessage: {}, data: {}", new Object[]{response.getErrorCode(), response.getErrorMessage(), strResp});
            try {
                EventSubResponse eventSubResponse = (EventSubResponse)this.objectMapper.readValue(strResp, EventSubResponse.class);
                callback.onReceiveLog(eventSubResponse.getId(), eventSubResponse.getStatus(), eventSubResponse.getLogs());
            }
            catch (JsonProcessingException e) {
                logger.error("subscribeEvent response parser json error, resp: {}, e: {}", (Object)strResp, (Object)e);
            }
        });
    }

    @Override
    public void unsubscribeEvent(String eventId) {
        this.eventSubJniObj.unsubscribeEvent(eventId);
    }

    @Override
    public Set<String> getAllSubscribedEvents() {
        return null;
    }

    @Override
    public void start() {
        this.eventSubJniObj.start();
    }

    @Override
    public void stop() {
        this.eventSubJniObj.stop();
    }

    @Override
    public void destroy() {
        if (this.eventSubJniObj != null) {
            BcosSDKJniObj.destroy((long)this.eventSubJniObj.getNativePointer());
            this.eventSubJniObj = null;
        }
    }
}

