/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.signature;

import org.fisco.bcos.sdk.v3.crypto.exceptions.SignatureException;
import org.fisco.bcos.sdk.v3.utils.Hex;

public abstract class SignatureResult {
    protected byte[] r;
    protected byte[] s;
    protected byte[] signatureBytes;

    SignatureResult(byte[] r, byte[] s) {
        this.r = r;
        this.s = s;
    }

    SignatureResult(String signatureString) {
        this.signatureBytes = Hex.decode(signatureString);
        if (this.signatureBytes.length < 64) {
            throw new SignatureException("Invalid signature: " + signatureString + ", signatureString len: " + signatureString.length() + ", signatureBytes size:" + this.signatureBytes.length);
        }
        this.r = new byte[32];
        System.arraycopy(this.signatureBytes, 0, this.r, 0, 32);
        this.s = new byte[32];
        System.arraycopy(this.signatureBytes, 32, this.s, 0, 32);
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public void setR(byte[] r) {
        this.r = r;
    }

    public void setS(byte[] s) {
        this.s = s;
    }

    public void setSignatureBytes(byte[] signatureBytes) {
        this.signatureBytes = signatureBytes;
    }

    public abstract String convertToString();

    public String toString() {
        return this.convertToString();
    }

    public abstract byte[] encode();
}

