/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.signature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.fisco.bcos.sdk.v3.crypto.exceptions.SignatureException;
import org.fisco.bcos.sdk.v3.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDSASignatureResult
extends SignatureResult {
    protected static Logger logger = LoggerFactory.getLogger(SignatureResult.class);
    protected byte v;
    protected static int VBASE = 27;

    public ECDSASignatureResult(byte v, byte[] r, byte[] s) {
        super(r, s);
        this.v = v;
    }

    public ECDSASignatureResult(String signatureResult) {
        super(signatureResult);
        if (this.signatureBytes.length != 65) {
            throw new SignatureException("Invalid signature for invalid length " + this.signatureBytes.length);
        }
        this.v = this.signatureBytes[64];
    }

    @Override
    public String convertToString() {
        byte[] SignatureBytes = new byte[65];
        System.arraycopy(this.r, 0, SignatureBytes, 0, 32);
        System.arraycopy(this.s, 0, SignatureBytes, 32, 32);
        SignatureBytes[64] = this.v;
        return Hex.toHexString(SignatureBytes);
    }

    @Override
    public String toString() {
        return this.convertToString();
    }

    @Override
    public byte[] encode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.r);
            byteArrayOutputStream.write(this.s);
            byteArrayOutputStream.write(this.v);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte getV() {
        return this.v;
    }

    public void setV(byte v) {
        this.v = v;
    }
}

