/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.signature;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import org.fisco.bcos.sdk.v3.crypto.exceptions.SignatureException;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.crypto.signature.ECDSASignatureResult;
import org.fisco.bcos.sdk.v3.crypto.signature.Signature;
import org.fisco.bcos.sdk.v3.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.fisco.bcos.sdk.v3.utils.Numeric;

public class ECDSASignature
implements Signature {
    private static int INPUT_MESSAGE_SIZE_IN_HEX = 64;

    @Override
    public SignatureResult sign(String message, CryptoKeyPair keyPair) {
        return new ECDSASignatureResult(this.signWithStringSignature(message, keyPair));
    }

    @Override
    public SignatureResult sign(byte[] message, CryptoKeyPair keyPair) {
        return this.sign(Hex.toHexString(message), keyPair);
    }

    private static void checkInputMessage(String message) {
        if (message.length() != INPUT_MESSAGE_SIZE_IN_HEX) {
            throw new SignatureException("Invalid input message " + message + ", must be a hex string of length 64");
        }
    }

    public static String signMessage(String message, CryptoKeyPair keyPair) {
        if (!keyPair.getCurveName().equals("secp256k1")) {
            throw new SignatureException("ecdsa sign with " + keyPair.getCurveName() + " keypair");
        }
        String inputMessage = Numeric.cleanHexPrefix(message);
        ECDSASignature.checkInputMessage(inputMessage);
        CryptoResult signatureResult = NativeInterface.secp256k1Sign((String)keyPair.getHexPrivateKey(), (String)inputMessage);
        if (signatureResult.wedprErrorMessage != null && !signatureResult.wedprErrorMessage.isEmpty()) {
            throw new SignatureException("Sign with secp256k1 failed:" + signatureResult.wedprErrorMessage);
        }
        return signatureResult.signature;
    }

    @Override
    public String signWithStringSignature(String message, CryptoKeyPair keyPair) {
        return ECDSASignature.signMessage(message, keyPair);
    }

    @Override
    public boolean verify(String publicKey, String message, String signature) {
        return ECDSASignature.verifyMessage(publicKey, message, signature);
    }

    @Override
    public boolean verify(String publicKey, byte[] message, byte[] signature) {
        return this.verify(publicKey, Hex.toHexString(message), Hex.toHexString(signature));
    }

    public static boolean verifyMessage(String publicKey, String message, String signature) {
        String inputMessage = Numeric.cleanHexPrefix(message);
        ECDSASignature.checkInputMessage(inputMessage);
        CryptoResult verifyResult = NativeInterface.secp256k1Verify((String)publicKey, (String)inputMessage, (String)signature);
        if (verifyResult.wedprErrorMessage != null && !verifyResult.wedprErrorMessage.isEmpty()) {
            throw new SignatureException("Verify with secp256k1 failed:" + verifyResult.wedprErrorMessage);
        }
        return verifyResult.booleanResult;
    }
}

