/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.keypair;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import java.math.BigInteger;
import java.security.KeyPair;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.jni.utilities.keypair.KeyPairJniObj;
import org.fisco.bcos.sdk.v3.crypto.hash.Hash;
import org.fisco.bcos.sdk.v3.crypto.hash.SM3Hash;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.crypto.keystore.KeyTool;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.fisco.bcos.sdk.v3.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2KeyPair
extends CryptoKeyPair {
    private static final Logger logger = LoggerFactory.getLogger(SM2KeyPair.class);
    public static Hash DefaultHashAlgorithm = new SM3Hash();

    public SM2KeyPair() {
        this.initSM2KeyPairObject();
        CryptoKeyPair keyPair = this.generateKeyPair();
        this.hexPrivateKey = keyPair.getHexPrivateKey();
        this.hexPublicKey = keyPair.getHexPublicKey();
        this.keyPair = KeyTool.convertHexedStringToKeyPair(this.hexPrivateKey, this.curveName);
        this.initJniKeyPair();
    }

    public SM2KeyPair(KeyPair javaKeyPair) {
        super(javaKeyPair);
        this.initSM2KeyPairObject();
        this.initJniKeyPair();
    }

    protected SM2KeyPair(CryptoResult sm2keyPairInfo) {
        super(sm2keyPairInfo);
        this.initSM2KeyPairObject();
        this.keyPair = KeyTool.convertHexedStringToKeyPair(this.hexPrivateKey, this.curveName);
        this.initJniKeyPair();
    }

    private void initSM2KeyPairObject() {
        this.keyStoreSubDir = "gm";
        this.hashImpl = new SM3Hash();
        this.curveName = "sm2p256v1";
        this.signatureAlgorithm = "1.2.156.10197.1.501";
    }

    private void initJniKeyPair() {
        try {
            this.jniKeyPair = KeyPairJniObj.createJniKeyPair((int)1, (byte[])Hex.decode(this.hexPrivateKey));
        }
        catch (JniException e) {
            logger.error("jni e: ", (Throwable)e);
        }
    }

    public static CryptoKeyPair createKeyPair() {
        return new SM2KeyPair(NativeInterface.sm2GenKeyPair());
    }

    @Override
    public CryptoKeyPair generateKeyPair() {
        return new SM2KeyPair(NativeInterface.sm2GenKeyPair());
    }

    @Override
    public CryptoKeyPair createKeyPair(KeyPair javaKeyPair) {
        return new SM2KeyPair(javaKeyPair);
    }

    public static String getAddressByPublicKey(String publicKey) {
        return SM2KeyPair.getAddress(publicKey, DefaultHashAlgorithm);
    }

    public static byte[] getAddressByPublicKey(byte[] publicKey) {
        return Hex.decode(Numeric.cleanHexPrefix(SM2KeyPair.getAddressByPublicKey(Hex.toHexString(publicKey))));
    }

    public static byte[] getAddressByPublicKey(BigInteger publicKey) {
        byte[] publicKeyBytes = Numeric.toBytesPadded(publicKey, 64);
        return SM2KeyPair.getAddressByPublicKey(publicKeyBytes);
    }
}

