/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.keypair;

import com.webank.wedpr.crypto.CryptoResult;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import org.fisco.bcos.sdk.v3.config.ConfigOption;
import org.fisco.bcos.sdk.v3.crypto.exceptions.KeyPairException;
import org.fisco.bcos.sdk.v3.crypto.hash.Hash;
import org.fisco.bcos.sdk.v3.crypto.keystore.KeyTool;
import org.fisco.bcos.sdk.v3.crypto.keystore.P12KeyStore;
import org.fisco.bcos.sdk.v3.crypto.keystore.PEMKeyStore;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.fisco.bcos.sdk.v3.utils.Numeric;
import org.fisco.bcos.sdk.v3.utils.exceptions.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CryptoKeyPair {
    protected static Logger logger = LoggerFactory.getLogger(CryptoKeyPair.class);
    public static final int ADDRESS_SIZE = 160;
    public static final int ADDRESS_LENGTH_IN_HEX = 40;
    public static final int PUBLIC_KEY_SIZE = 64;
    public static final int PUBLIC_KEY_LENGTH_IN_HEX = 128;
    public static final int PRIVATE_KEY_SIZE = 32;
    public static final int PRIVATE_KEY_SIZE_IN_HEX = 64;
    public static final String ECDSA_CURVE_NAME = "secp256k1";
    public static final String SM2_CURVE_NAME = "sm2p256v1";
    public static final String PEM_FILE_POSTFIX = ".pem";
    public static final String P12_FILE_POSTFIX = ".p12";
    public static final String GM_ACCOUNT_SUBDIR = "gm";
    public static final String ECDSA_ACCOUNT_SUBDIR = "ecdsa";
    public static final String UNCOMPRESSED_PUBLICKEY_FLAG_STR = "04";
    protected static final String ECDSA_SIGNATURE_ALGORITHM = "SHA256WITHECDSA";
    protected static final String SM_SIGNATURE_ALGORITHM = "1.2.156.10197.1.501";
    protected String hexPrivateKey;
    protected String hexPublicKey;
    public KeyPair keyPair;
    protected Hash hashImpl;
    protected String curveName;
    protected String keyStoreSubDir = "";
    protected ConfigOption config;
    protected String pemKeyStoreFilePath = "";
    protected String p12KeyStoreFilePath = "";
    protected String signatureAlgorithm;
    protected long jniKeyPair;

    public CryptoKeyPair() {
    }

    public CryptoKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        this.hexPrivateKey = KeyTool.getHexedPrivateKey(keyPair.getPrivate());
        this.hexPublicKey = KeyTool.getHexedPublicKey(keyPair.getPublic());
    }

    CryptoKeyPair(CryptoResult nativeResult) {
        this.hexPrivateKey = nativeResult.privateKey;
        this.hexPublicKey = CryptoKeyPair.getPublicKeyNoPrefix(nativeResult.publicKey);
    }

    public long getJniKeyPair() {
        return this.jniKeyPair;
    }

    public void setConfig(ConfigOption config) {
        this.config = config;
    }

    public String getHexPrivateKey() {
        return this.hexPrivateKey;
    }

    public String getHexPublicKey() {
        return this.hexPublicKey;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public abstract CryptoKeyPair generateKeyPair();

    public String getCurveName() {
        return this.curveName;
    }

    public abstract CryptoKeyPair createKeyPair(KeyPair var1);

    public CryptoKeyPair createKeyPair(BigInteger privateKeyValue) {
        KeyPair keyPair = KeyTool.convertPrivateKeyToKeyPair(privateKeyValue, this.curveName);
        return this.createKeyPair(keyPair);
    }

    public CryptoKeyPair createKeyPair(String hexPrivateKey) {
        KeyPair keyPair = KeyTool.convertHexedStringToKeyPair(hexPrivateKey, this.curveName);
        return this.createKeyPair(keyPair);
    }

    protected static String getPublicKeyNoPrefix(String publicKeyStr) {
        return Numeric.getKeyNoPrefix(UNCOMPRESSED_PUBLICKEY_FLAG_STR, publicKeyStr, 128);
    }

    public String getAddress() {
        return this.getAddress(this.getHexPublicKey());
    }

    public String getAddress(String publicKey) {
        return CryptoKeyPair.getAddress(publicKey, this.hashImpl);
    }

    protected static String getAddress(String publicKey, Hash hashInterface) {
        try {
            String publicKeyNoPrefix = Numeric.getKeyNoPrefix(UNCOMPRESSED_PUBLICKEY_FLAG_STR, publicKey, 128);
            String publicKeyHash = Hex.toHexString(hashInterface.hash(Hex.decode(publicKeyNoPrefix)));
            return "0x" + publicKeyHash.substring(publicKeyHash.length() - 40);
        }
        catch (DecoderException e) {
            throw new KeyPairException("getAddress for " + publicKey + "failed, the publicKey param must be hex string, error message: " + e.getMessage(), e);
        }
    }

    public byte[] getAddress(byte[] publicKey) {
        return Hex.decode(Numeric.cleanHexPrefix(this.getAddress(Hex.toHexString(publicKey))));
    }

    public byte[] getAddress(BigInteger publicKey) {
        byte[] publicKeyBytes = Numeric.toBytesPadded(publicKey, 64);
        return this.getAddress(publicKeyBytes);
    }

    public void storeKeyPairWithPem(String keyStoreFilePath) {
        PEMKeyStore.storeKeyPairWithPemFormat(this.hexPrivateKey, keyStoreFilePath, this.curveName);
    }

    public void storeKeyPairWithPemFormat() {
        String pemKeyStoreFilePath = this.getPemKeyStoreFilePath();
        File file = new File(pemKeyStoreFilePath);
        if (file.exists()) {
            return;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        logger.debug("store account {} to pem file: {}", (Object)this.getAddress(), (Object)pemKeyStoreFilePath);
        this.storeKeyPairWithPem(pemKeyStoreFilePath);
    }

    public void storeKeyPairWithP12(String p12FilePath, String password) {
        P12KeyStore.storeKeyPairWithP12Format(this.hexPrivateKey, password, p12FilePath, this.curveName, this.signatureAlgorithm);
    }

    public void storeKeyPairWithP12Format(String password) {
        String p12KeyStoreFilePath = this.getP12KeyStoreFilePath();
        File file = new File(p12KeyStoreFilePath);
        if (file.exists()) {
            return;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        logger.debug("store account {} to p12 file: {}", (Object)this.getAddress(), (Object)p12KeyStoreFilePath);
        this.storeKeyPairWithP12(p12KeyStoreFilePath, password);
    }

    public String getKeyStoreSubDir() {
        return this.keyStoreSubDir;
    }

    public String getPemKeyStoreFilePath() {
        if (!this.pemKeyStoreFilePath.equals("")) {
            return this.pemKeyStoreFilePath;
        }
        this.pemKeyStoreFilePath = this.getPemKeyStoreFilePath(this.getAddress());
        return this.pemKeyStoreFilePath;
    }

    public String getPemKeyStoreFilePath(String address) {
        return this.getKeyStoreFilePath(address, PEM_FILE_POSTFIX);
    }

    public String getP12KeyStoreFilePath(String address) {
        return this.getKeyStoreFilePath(address, P12_FILE_POSTFIX);
    }

    public String getP12KeyStoreFilePath() {
        if (!this.p12KeyStoreFilePath.equals("")) {
            return this.p12KeyStoreFilePath;
        }
        this.p12KeyStoreFilePath = this.getP12KeyStoreFilePath(this.getAddress());
        return this.p12KeyStoreFilePath;
    }

    protected String getKeyStoreFilePath(String address, String postFix) {
        String keyStoreFileDir = "account";
        if (this.config != null) {
            keyStoreFileDir = this.config.getAccountConfig().getKeyStoreDir();
        }
        keyStoreFileDir = keyStoreFileDir + "/" + this.keyStoreSubDir + "/";
        return keyStoreFileDir + address + postFix;
    }
}

