/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.hash;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import org.fisco.bcos.sdk.v3.crypto.exceptions.HashException;
import org.fisco.bcos.sdk.v3.crypto.hash.Hash;
import org.fisco.bcos.sdk.v3.utils.Hex;

public class SM3Hash
implements Hash {
    @Override
    public String hash(String inputData) {
        return SM3Hash.calculateHash(inputData.getBytes());
    }

    @Override
    public String hashBytes(byte[] inputBytes) {
        return SM3Hash.calculateHash(inputBytes);
    }

    @Override
    public byte[] hash(byte[] inputBytes) {
        return Hex.decode(SM3Hash.calculateHash(inputBytes));
    }

    public static String calculateHash(byte[] inputBytes) {
        CryptoResult hashResult = NativeInterface.sm3Hash((String)Hex.toHexString(inputBytes));
        if (hashResult.wedprErrorMessage != null && !hashResult.wedprErrorMessage.isEmpty()) {
            throw new HashException("calculate hash with sm3 failed, error message:" + hashResult.wedprErrorMessage);
        }
        return hashResult.hash;
    }
}

