/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto;

import java.security.KeyPair;
import org.fisco.bcos.sdk.v3.config.ConfigOption;
import org.fisco.bcos.sdk.v3.config.model.AccountConfig;
import org.fisco.bcos.sdk.v3.crypto.exceptions.LoadKeyStoreException;
import org.fisco.bcos.sdk.v3.crypto.exceptions.UnsupportedCryptoTypeException;
import org.fisco.bcos.sdk.v3.crypto.hash.Hash;
import org.fisco.bcos.sdk.v3.crypto.hash.Keccak256;
import org.fisco.bcos.sdk.v3.crypto.hash.SM3Hash;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.crypto.keypair.ECDSAKeyPair;
import org.fisco.bcos.sdk.v3.crypto.keypair.SM2KeyPair;
import org.fisco.bcos.sdk.v3.crypto.keystore.KeyTool;
import org.fisco.bcos.sdk.v3.crypto.keystore.P12KeyStore;
import org.fisco.bcos.sdk.v3.crypto.keystore.PEMKeyStore;
import org.fisco.bcos.sdk.v3.crypto.signature.ECDSASignature;
import org.fisco.bcos.sdk.v3.crypto.signature.SM2Signature;
import org.fisco.bcos.sdk.v3.crypto.signature.Signature;
import org.fisco.bcos.sdk.v3.crypto.signature.SignatureResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoSuite {
    private static final Logger logger = LoggerFactory.getLogger(CryptoSuite.class);
    public final int cryptoTypeConfig;
    public final Signature signatureImpl;
    public final Hash hashImpl;
    private final CryptoKeyPair keyPairFactory;
    private CryptoKeyPair cryptoKeyPair;
    private ConfigOption config;

    public CryptoSuite(int cryptoTypeConfig, CryptoKeyPair cryptoKeyPair) {
        this(cryptoTypeConfig);
        this.cryptoKeyPair = cryptoKeyPair;
    }

    public CryptoSuite(int cryptoTypeConfig, String hexedPrivateKey) {
        this(cryptoTypeConfig);
        this.cryptoKeyPair = this.keyPairFactory.createKeyPair(hexedPrivateKey);
    }

    public CryptoSuite(int cryptoTypeConfig, ConfigOption configOption) {
        this(cryptoTypeConfig);
        logger.info("init CryptoSuite, cryptoType: {}", (Object)cryptoTypeConfig);
        this.setConfig(configOption);
        if (!configOption.getAccountConfig().isAccountConfigured()) {
            this.generateRandomKeyPair();
            return;
        }
        this.loadAccount(configOption);
    }

    public CryptoSuite(int cryptoTypeConfig) {
        this.cryptoTypeConfig = cryptoTypeConfig;
        if (this.cryptoTypeConfig == 0) {
            this.signatureImpl = new ECDSASignature();
            this.hashImpl = new Keccak256();
            this.keyPairFactory = new ECDSAKeyPair();
        } else if (this.cryptoTypeConfig == 1) {
            this.signatureImpl = new SM2Signature();
            this.hashImpl = new SM3Hash();
            this.keyPairFactory = new SM2KeyPair();
        } else {
            throw new UnsupportedCryptoTypeException("only support 0/1 crypto type");
        }
        this.generateRandomKeyPair();
    }

    public void loadAccount(String accountFileFormat, String accountFilePath, String password) {
        KeyTool keyTool = null;
        if (accountFileFormat.compareToIgnoreCase("p12") == 0) {
            keyTool = new P12KeyStore(accountFilePath, password);
        } else if (accountFileFormat.compareToIgnoreCase("pem") == 0) {
            keyTool = new PEMKeyStore(accountFilePath);
        } else {
            throw new LoadKeyStoreException("unsupported account file format : " + accountFileFormat + ", current supported are p12 and pem");
        }
        logger.debug("Load account from {}", (Object)accountFilePath);
        this.loadKeyPair(keyTool.getKeyPair());
    }

    private void loadAccount(ConfigOption configOption) {
        AccountConfig accountConfig = configOption.getAccountConfig();
        String accountFilePath = accountConfig.getAccountFilePath();
        if (accountFilePath == null || accountFilePath.equals("")) {
            if (accountConfig.getAccountFileFormat().compareToIgnoreCase("p12") == 0) {
                accountFilePath = this.keyPairFactory.getP12KeyStoreFilePath(accountConfig.getAccountAddress());
            } else if (accountConfig.getAccountFileFormat().compareToIgnoreCase("pem") == 0) {
                accountFilePath = this.keyPairFactory.getPemKeyStoreFilePath(accountConfig.getAccountAddress());
            }
        }
        this.loadAccount(accountConfig.getAccountFileFormat(), accountFilePath, accountConfig.getAccountPassword());
    }

    public void setConfig(ConfigOption config) {
        this.config = config;
        this.keyPairFactory.setConfig(config);
    }

    public int getCryptoTypeConfig() {
        return this.cryptoTypeConfig;
    }

    public Signature getSignatureImpl() {
        return this.signatureImpl;
    }

    public Hash getHashImpl() {
        return this.hashImpl;
    }

    public String hash(String inputData) {
        return this.hashImpl.hash(inputData);
    }

    public byte[] hash(byte[] inputBytes) {
        return this.hashImpl.hash(inputBytes);
    }

    public SignatureResult sign(byte[] message, CryptoKeyPair keyPair) {
        return this.signatureImpl.sign(message, keyPair);
    }

    public SignatureResult sign(String message, CryptoKeyPair keyPair) {
        return this.signatureImpl.sign(message, keyPair);
    }

    public String sign(KeyTool keyTool, String message) {
        CryptoKeyPair cryptoKeyPair = this.keyPairFactory.createKeyPair(keyTool.getKeyPair());
        return this.signatureImpl.signWithStringSignature(message, cryptoKeyPair);
    }

    public boolean verify(KeyTool keyTool, String message, String signature) {
        return this.verify(keyTool.getHexedPublicKey(), message, signature);
    }

    public boolean verify(KeyTool keyTool, byte[] message, byte[] signature) {
        return this.verify(keyTool.getHexedPublicKey(), message, signature);
    }

    public boolean verify(String publicKey, String message, String signature) {
        return this.signatureImpl.verify(publicKey, message, signature);
    }

    public boolean verify(String publicKey, byte[] message, byte[] signature) {
        return this.signatureImpl.verify(publicKey, message, signature);
    }

    public CryptoKeyPair generateRandomKeyPair() {
        this.cryptoKeyPair = this.keyPairFactory.generateKeyPair();
        this.cryptoKeyPair.setConfig(this.config);
        return this.cryptoKeyPair;
    }

    public CryptoKeyPair loadKeyPair(KeyPair keyPair) {
        this.cryptoKeyPair = this.keyPairFactory.createKeyPair(keyPair);
        this.cryptoKeyPair.setConfig(this.config);
        return this.cryptoKeyPair;
    }

    public CryptoKeyPair loadKeyPair(String hexedPrivateKey) {
        this.cryptoKeyPair = this.keyPairFactory.createKeyPair(hexedPrivateKey);
        this.cryptoKeyPair.setConfig(this.config);
        return this.cryptoKeyPair;
    }

    public void setCryptoKeyPair(CryptoKeyPair cryptoKeyPair) {
        this.cryptoKeyPair = cryptoKeyPair;
        this.cryptoKeyPair.setConfig(this.config);
    }

    public CryptoKeyPair getCryptoKeyPair() {
        return this.cryptoKeyPair;
    }

    public ConfigOption getConfig() {
        return this.config;
    }

    public CryptoKeyPair getKeyPairFactory() {
        return this.keyPairFactory;
    }
}

