/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.precompiled.crud.common;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.TablePrecompiled;

public class Condition {
    private final Map<ConditionOperator, String> conditions = new HashMap<ConditionOperator, String>();
    private TablePrecompiled.Limit limit = new TablePrecompiled.Limit();
    private String eqValue = "";

    public void GT(String value) {
        this.conditions.put(ConditionOperator.GT, value);
    }

    public void GE(String value) {
        this.conditions.put(ConditionOperator.GE, value);
    }

    public void LT(String value) {
        this.conditions.put(ConditionOperator.LT, value);
    }

    public void LE(String value) {
        this.conditions.put(ConditionOperator.LE, value);
    }

    public void EQ(String value) {
        this.eqValue = value;
    }

    public void setLimit(int offset, int count) {
        this.limit = new TablePrecompiled.Limit(offset, count);
    }

    public void setLimit(BigInteger offset, BigInteger count) {
        this.limit = new TablePrecompiled.Limit(offset, count);
    }

    public Map<ConditionOperator, String> getConditions() {
        return this.conditions;
    }

    public String getEqValue() {
        return this.eqValue;
    }

    public List<TablePrecompiled.Condition> getTableConditions() {
        ArrayList<TablePrecompiled.Condition> tableConditions = new ArrayList<TablePrecompiled.Condition>();
        this.conditions.forEach((op, value) -> tableConditions.add(new TablePrecompiled.Condition(op.getBigIntValue(), (String)value)));
        return tableConditions;
    }

    public TablePrecompiled.Limit getLimit() {
        return this.limit;
    }

    public String toString() {
        return "Condition{conditions=" + this.conditions + ", limit=" + this.limit + ", eqValue='" + this.eqValue + '\'' + '}';
    }

    public static enum ConditionOperator {
        GT(0),
        GE(1),
        LT(2),
        LE(3),
        EQ(4);

        private final int value;

        private ConditionOperator(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public BigInteger getBigIntValue() {
            return BigInteger.valueOf(this.value);
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "GT";
                }
                case 1: {
                    return "GE";
                }
                case 2: {
                    return "LT";
                }
                case 3: {
                    return "LE";
                }
                case 4: {
                    return "EQ";
                }
            }
            return "";
        }
    }
}

