/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.precompiled.crud;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.contract.precompiled.callback.PrecompiledCallback;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.TableManagerPrecompiled;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.TablePrecompiled;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.common.Condition;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.common.Entry;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.common.UpdateFields;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.model.PrecompiledRetCode;
import org.fisco.bcos.sdk.v3.model.RetCode;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.v3.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCRUDService {
    private final Client client;
    private final TableManagerPrecompiled tableManagerPrecompiled;
    private final Logger logger = LoggerFactory.getLogger(TableCRUDService.class);

    public TableCRUDService(Client client, CryptoKeyPair credential) {
        this.client = client;
        this.tableManagerPrecompiled = TableManagerPrecompiled.load(this.client.isWASM() != false ? "/sys/table_manager" : "0000000000000000000000000000000000001002", client, credential);
    }

    public RetCode createTable(String tableName, String keyFieldName, List<String> valueFields) throws ContractException {
        TableManagerPrecompiled.TableInfo tableInfo = new TableManagerPrecompiled.TableInfo(keyFieldName, valueFields);
        TransactionReceipt receipt = this.tableManagerPrecompiled.createTable(tableName, tableInfo);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> this.tableManagerPrecompiled.getCreateTableOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncCreateTable(String tableName, String keyFieldName, List<String> valueFields, PrecompiledCallback callback) {
        TableManagerPrecompiled.TableInfo tableInfo = new TableManagerPrecompiled.TableInfo(keyFieldName, valueFields);
        this.tableManagerPrecompiled.createTable(tableName, tableInfo, this.createTransactionCallback(callback, transactionReceipt -> this.tableManagerPrecompiled.getCreateTableOutput((TransactionReceipt)transactionReceipt).getValue1()));
    }

    public RetCode appendColumns(String tableName, List<String> newColumns) throws ContractException {
        TransactionReceipt receipt = this.tableManagerPrecompiled.appendColumns(tableName, newColumns);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> this.tableManagerPrecompiled.getAppendColumnsOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncAppendColumns(String tableName, List<String> newColumns, PrecompiledCallback callback) {
        this.tableManagerPrecompiled.appendColumns(tableName, newColumns, this.createTransactionCallback(callback, transactionReceipt -> this.tableManagerPrecompiled.getAppendColumnsOutput((TransactionReceipt)transactionReceipt).getValue1()));
    }

    public List<Map<String, String>> select(String tableName, Condition condition) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        TableManagerPrecompiled.TableInfo tableInfo = this.tableManagerPrecompiled.desc(tableName);
        List selectEntry = tablePrecompiled.select(condition.getTableConditions(), condition.getLimit());
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (TablePrecompiled.Entry entry : selectEntry) {
            HashMap<String, String> kvs = new HashMap<String, String>();
            kvs.put(tableInfo.keyColumn, entry.key);
            for (int i = 0; i < entry.fields.size(); ++i) {
                kvs.put(tableInfo.valueColumns.get(i), entry.fields.get(i));
            }
            result.add(kvs);
        }
        return result;
    }

    public List<Map<String, String>> select(String tableName, Map<String, List<String>> desc, Condition condition) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        List selectEntry = tablePrecompiled.select(condition.getTableConditions(), condition.getLimit());
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (TablePrecompiled.Entry entry : selectEntry) {
            HashMap<String, String> kvs = new HashMap<String, String>();
            kvs.put(desc.get("key_field").get(0), entry.key);
            for (int i = 0; i < entry.fields.size(); ++i) {
                kvs.put(desc.get("value_field").get(i), entry.fields.get(i));
            }
            result.add(kvs);
        }
        return result;
    }

    public Map<String, String> select(String tableName, String key) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        TableManagerPrecompiled.TableInfo tableInfo = this.tableManagerPrecompiled.desc(tableName);
        TablePrecompiled.Entry selectEntry = tablePrecompiled.select(key);
        HashMap<String, String> result = new HashMap<String, String>();
        if (selectEntry.fields.isEmpty()) {
            return result;
        }
        result.put(tableInfo.keyColumn, selectEntry.key);
        for (int i = 0; i < selectEntry.fields.size(); ++i) {
            result.put(tableInfo.valueColumns.get(i), selectEntry.fields.get(i));
        }
        return result;
    }

    public Map<String, String> select(String tableName, Map<String, List<String>> desc, String key) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        TablePrecompiled.Entry selectEntry = tablePrecompiled.select(key);
        HashMap<String, String> result = new HashMap<String, String>();
        if (selectEntry.fields.isEmpty()) {
            return result;
        }
        result.put(desc.get("key_field").get(0), selectEntry.key);
        for (int i = 0; i < selectEntry.fields.size(); ++i) {
            result.put(desc.get("value_field").get(i), selectEntry.fields.get(i));
        }
        return result;
    }

    public RetCode insert(String tableName, Entry entry) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        return this.insert(tablePrecompiled, entry);
    }

    public RetCode insert(TablePrecompiled tablePrecompiled, Entry entry) throws ContractException {
        TransactionReceipt transactionReceipt = tablePrecompiled.insert(entry.covertToEntry());
        return this.getCurdRetCode(transactionReceipt, tr -> tablePrecompiled.getInsertOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncInsert(String tableName, Entry entry, PrecompiledCallback callback) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        tablePrecompiled.insert(entry.covertToEntry(), this.createTransactionCallback(callback, transactionReceipt -> tablePrecompiled.getInsertOutput((TransactionReceipt)transactionReceipt).getValue1()));
    }

    public RetCode update(String tableName, String key, UpdateFields updateFields) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        return this.update(tablePrecompiled, key, updateFields);
    }

    public RetCode update(TablePrecompiled tablePrecompiled, String key, UpdateFields updateFields) throws ContractException {
        TransactionReceipt transactionReceipt = tablePrecompiled.update(key, updateFields.convertToUpdateFields());
        return this.getCurdRetCode(transactionReceipt, tr -> tablePrecompiled.getUpdateOutput((TransactionReceipt)tr).getValue1());
    }

    public RetCode update(String tableName, Condition condition, UpdateFields updateFields) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        return this.update(tablePrecompiled, condition, updateFields);
    }

    public RetCode update(TablePrecompiled tablePrecompiled, Condition condition, UpdateFields updateFields) throws ContractException {
        TransactionReceipt transactionReceipt = tablePrecompiled.update(condition.getTableConditions(), condition.getLimit(), updateFields.convertToUpdateFields());
        return this.getCurdRetCode(transactionReceipt, tr -> tablePrecompiled.getUpdateOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncUpdate(String tableName, String key, UpdateFields updateFields, PrecompiledCallback callback) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        tablePrecompiled.update(key, updateFields.convertToUpdateFields(), this.createTransactionCallback(callback, transactionReceipt -> tablePrecompiled.getUpdateOutput((TransactionReceipt)transactionReceipt).getValue1()));
    }

    public void asyncUpdate(String tableName, Condition condition, UpdateFields updateFields, PrecompiledCallback callback) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        tablePrecompiled.update(condition.getTableConditions(), condition.getLimit(), updateFields.convertToUpdateFields(), this.createTransactionCallback(callback, transactionReceipt -> tablePrecompiled.getUpdateOutput((TransactionReceipt)transactionReceipt).getValue1()));
    }

    public RetCode remove(String tableName, String key) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        return this.remove(tablePrecompiled, key);
    }

    public RetCode remove(TablePrecompiled tablePrecompiled, String key) throws ContractException {
        TransactionReceipt transactionReceipt = tablePrecompiled.remove(key);
        return this.getCurdRetCode(transactionReceipt, tr -> tablePrecompiled.getRemoveOutput((TransactionReceipt)tr).getValue1());
    }

    public RetCode remove(String tableName, Condition condition) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        return this.remove(tablePrecompiled, condition);
    }

    public RetCode remove(TablePrecompiled tablePrecompiled, Condition condition) throws ContractException {
        TransactionReceipt transactionReceipt = tablePrecompiled.remove(condition.getTableConditions(), condition.getLimit());
        return this.getCurdRetCode(transactionReceipt, tr -> tablePrecompiled.getRemoveOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncRemove(String tableName, String key, PrecompiledCallback callback) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        tablePrecompiled.remove(key, this.createTransactionCallback(callback, transactionReceipt -> tablePrecompiled.getRemoveOutput((TransactionReceipt)transactionReceipt).getValue1()));
    }

    public void asyncRemove(String tableName, Condition condition, PrecompiledCallback callback) throws ContractException {
        TablePrecompiled tablePrecompiled = this.loadTablePrecompiled(tableName);
        tablePrecompiled.remove(condition.getTableConditions(), condition.getLimit(), this.createTransactionCallback(callback, transactionReceipt -> tablePrecompiled.getRemoveOutput((TransactionReceipt)transactionReceipt).getValue1()));
    }

    public Map<String, List<String>> desc(String tableName) throws ContractException {
        TableManagerPrecompiled.TableInfo tableInfo = this.tableManagerPrecompiled.desc(tableName);
        if (tableInfo.keyColumn.isEmpty() || tableInfo.valueColumns.isEmpty()) {
            throw new ContractException("Table " + tableName + " does not exist.");
        }
        HashMap<String, List<String>> descMap = new HashMap<String, List<String>>();
        descMap.put("key_field", Collections.singletonList(tableInfo.keyColumn));
        descMap.put("value_field", tableInfo.valueColumns);
        return descMap;
    }

    private TransactionCallback createTransactionCallback(final PrecompiledCallback callback, final Function<TransactionReceipt, BigInteger> resultCaller) {
        return new TransactionCallback(){

            @Override
            public void onResponse(TransactionReceipt receipt) {
                RetCode retCode;
                try {
                    retCode = TableCRUDService.this.getCurdRetCode(receipt, resultCaller);
                }
                catch (ContractException e) {
                    retCode = new RetCode(e.getErrorCode(), e.getMessage());
                    retCode.setTransactionReceipt(receipt);
                }
                callback.onResponse(retCode);
            }
        };
    }

    private RetCode getCurdRetCode(TransactionReceipt transactionReceipt, Function<TransactionReceipt, BigInteger> resultCaller) throws ContractException {
        int status = transactionReceipt.getStatus();
        if (status != 0) {
            ReceiptParser.getErrorStatus(transactionReceipt);
        }
        BigInteger result = resultCaller.apply(transactionReceipt);
        return PrecompiledRetCode.getPrecompiledResponse(result.intValue(), transactionReceipt.getMessage());
    }

    private String getTableName(String tableName) {
        if (tableName.length() > "/tables/".length() && tableName.startsWith("/tables/")) {
            return tableName;
        }
        return "/tables/" + (tableName.startsWith("/") ? tableName.substring(1) : tableName);
    }

    private TablePrecompiled loadTablePrecompiled(String tableName) throws ContractException {
        String address;
        String string = address = this.client.isWASM() != false ? this.getTableName(tableName) : this.tableManagerPrecompiled.openTable(tableName);
        if (StringUtils.isEmpty(address)) {
            this.logger.error("Empty address when loadTablePrecompiled, tableName: {}", (Object)tableName);
            throw new ContractException("Empty address when loadTablePrecompiled, tableName: " + tableName);
        }
        return TablePrecompiled.load(address, this.client, this.client.getCryptoSuite().getCryptoKeyPair());
    }
}

