/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.precompiled.crud;

import java.util.HashMap;
import java.util.Map;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.v3.contract.precompiled.callback.PrecompiledCallback;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.KVTablePrecompiled;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.TableManagerPrecompiled;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.model.RetCode;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.v3.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVTableService {
    private final Client client;
    private final TableManagerPrecompiled tableManagerPrecompiled;
    private final Logger logger = LoggerFactory.getLogger(KVTableService.class);

    public KVTableService(Client client, CryptoKeyPair credential) {
        this.client = client;
        this.tableManagerPrecompiled = TableManagerPrecompiled.load(this.client.isWASM() != false ? "/sys/table_manager" : "0000000000000000000000000000000000001002", client, credential);
    }

    public void checkKey(String key) throws ContractException {
        if (key.length() > 255) {
            throw new ContractException("The length of the table key exceeds the maximum limit 255");
        }
    }

    public RetCode createTable(String tableName, String keyFieldName, String valueField) throws ContractException {
        this.checkKey(keyFieldName);
        TransactionReceipt transactionReceipt = this.tableManagerPrecompiled.createKVTable(tableName, keyFieldName, valueField);
        return ReceiptParser.parseTransactionReceipt(transactionReceipt, tr -> this.tableManagerPrecompiled.getCreateKVTableOutput((TransactionReceipt)tr).getValue1());
    }

    public RetCode set(String tableName, String key, String value) throws ContractException {
        KVTablePrecompiled kvTablePrecompiled = this.loadKVTablePrecompiled(tableName);
        return this.set(kvTablePrecompiled, key, value);
    }

    public RetCode set(KVTablePrecompiled kvTablePrecompiled, String key, String value) throws ContractException {
        TransactionReceipt receipt = kvTablePrecompiled.set(key, value);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> kvTablePrecompiled.getSetOutput((TransactionReceipt)tr).getValue1());
    }

    public String get(String tableName, String key) throws ContractException {
        KVTablePrecompiled kvTablePrecompiled = this.loadKVTablePrecompiled(tableName);
        return this.get(kvTablePrecompiled, key);
    }

    public String get(KVTablePrecompiled kvTablePrecompiled, String key) throws ContractException {
        Tuple2<Boolean, String> booleanStringTuple = kvTablePrecompiled.get(key);
        if (!booleanStringTuple.getValue1().booleanValue()) {
            throw new ContractException("get from " + kvTablePrecompiled.getContractAddress() + " failed, return false.");
        }
        return booleanStringTuple.getValue2();
    }

    public Map<String, String> desc(String tableName) throws ContractException {
        TableManagerPrecompiled.TableInfo desc = this.tableManagerPrecompiled.desc(tableName);
        HashMap<String, String> tableDesc = new HashMap<String, String>();
        tableDesc.put("key_field", desc.keyColumn);
        tableDesc.put("value_field", desc.valueColumns.get(0));
        return tableDesc;
    }

    public void asyncSet(String tableName, String key, String value, PrecompiledCallback callback) throws ContractException {
        KVTablePrecompiled kvTablePrecompiled = this.loadKVTablePrecompiled(tableName);
        this.asyncSet(kvTablePrecompiled, key, value, callback);
    }

    public void asyncSet(final KVTablePrecompiled kvTablePrecompiled, String key, String value, final PrecompiledCallback callback) {
        kvTablePrecompiled.set(key, value, new TransactionCallback(){

            @Override
            public void onResponse(TransactionReceipt receipt) {
                RetCode retCode;
                try {
                    retCode = ReceiptParser.parseTransactionReceipt(receipt, tr -> kvTablePrecompiled.getSetOutput((TransactionReceipt)tr).getValue1());
                }
                catch (ContractException e) {
                    retCode = new RetCode(e.getErrorCode(), e.getMessage());
                    retCode.setTransactionReceipt(receipt);
                }
                callback.onResponse(retCode);
            }
        });
    }

    private String getTableName(String tableName) {
        if (tableName.length() > "/tables/".length() && tableName.startsWith("/tables/")) {
            return tableName;
        }
        return "/tables/" + (tableName.startsWith("/") ? tableName.substring(1) : tableName);
    }

    private KVTablePrecompiled loadKVTablePrecompiled(String tableName) throws ContractException {
        String address;
        String string = address = this.client.isWASM() != false ? this.getTableName(tableName) : this.tableManagerPrecompiled.openTable(tableName);
        if (StringUtils.isEmpty(address)) {
            this.logger.error("Empty address when loadKVTablePrecompiled, tableName: {}", (Object)tableName);
            throw new ContractException("Empty address when loadKVTablePrecompiled, tableName: " + tableName);
        }
        return KVTablePrecompiled.load(address, this.client, this.client.getCryptoSuite().getCryptoKeyPair());
    }
}

