/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.precompiled.consensus;

import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.client.protocol.response.SealerList;
import org.fisco.bcos.sdk.v3.contract.precompiled.consensus.ConsensusPrecompiled;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.model.RetCode;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;

public class ConsensusService {
    private final ConsensusPrecompiled consensusPrecompiled;
    private final Client client;

    public ConsensusService(Client client, CryptoKeyPair credential) {
        this.client = client;
        this.consensusPrecompiled = ConsensusPrecompiled.load(client.isWASM() != false ? "/sys/consensus" : "0000000000000000000000000000000000001003", client, credential);
    }

    private boolean existsInNodeList(String nodeId) {
        List<String> nodeIdList = this.client.getGroupPeers().getGroupPeers();
        if (nodeIdList == null) {
            return false;
        }
        return nodeIdList.contains(nodeId);
    }

    public RetCode addSealer(String nodeId, BigInteger weight) throws ContractException {
        if (!this.existsInNodeList(nodeId)) {
            throw new ContractException("The operated node must be in the list returned by getGroupPeers");
        }
        List sealerList = (List)this.client.getSealerList().getResult();
        if (sealerList != null) {
            for (SealerList.Sealer sealer : sealerList) {
                if (!sealer.getNodeID().equals(nodeId)) continue;
                throw new ContractException("The node already exists in the sealerList");
            }
        }
        TransactionReceipt receipt = this.consensusPrecompiled.addSealer(nodeId, weight);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> this.consensusPrecompiled.getAddSealerOutput((TransactionReceipt)tr).getValue1());
    }

    public RetCode addObserver(String nodeId) throws ContractException {
        if (!this.existsInNodeList(nodeId)) {
            throw new ContractException("The operated node must be in the list returned by getGroupPeers");
        }
        List observerList = (List)this.client.getObserverList().getResult();
        if (observerList.contains(nodeId)) {
            throw new ContractException("The node already exists in the observerList");
        }
        TransactionReceipt receipt = this.consensusPrecompiled.addObserver(nodeId);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> this.consensusPrecompiled.getAddObserverOutput((TransactionReceipt)tr).getValue1());
    }

    public RetCode removeNode(String nodeId) throws ContractException {
        TransactionReceipt receipt = this.consensusPrecompiled.remove(nodeId);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> this.consensusPrecompiled.getRemoveOutput((TransactionReceipt)tr).getValue1());
    }

    public RetCode setWeight(String nodeId, BigInteger weight) throws ContractException {
        TransactionReceipt receipt = this.consensusPrecompiled.setWeight(nodeId, weight);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> this.consensusPrecompiled.getSetWeightOutput((TransactionReceipt)tr).getValue1());
    }
}

