/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.auth.po;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.fisco.bcos.sdk.v3.codec.datatypes.Address;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Uint256;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Uint8;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.tuples.generated.Tuple7;
import org.fisco.bcos.sdk.v3.contract.auth.po.ProposalStatus;
import org.fisco.bcos.sdk.v3.contract.auth.po.ProposalType;

public class ProposalInfo
extends DynamicStruct {
    private String resourceId;
    private String proposer;
    private int proposalType;
    private BigInteger blockNumberInterval;
    private int status;
    private List<String> agreeVoters;
    private List<String> againstVoters;

    public ProposalInfo() {
        super(new Type[]{new Address(""), new Uint8(0L), new Uint256(0L), new Uint8(0L), new DynamicArray(Address.class, (Type[])new Address[0]), new DynamicArray(Address.class, (Type[])new Address[0])});
    }

    public ProposalInfo(Address resourceId, Address proposer, Uint8 proposalType, Uint256 blockNumberInterval, Uint8 status, DynamicArray<Address> agreeVoters, DynamicArray<Address> againstVoters) {
        super(new Type[]{resourceId, proposer, proposalType, blockNumberInterval, status, agreeVoters, againstVoters});
        this.resourceId = resourceId.getValue();
        this.proposer = proposer.getValue();
        this.proposalType = proposalType.getValue().intValue();
        this.blockNumberInterval = blockNumberInterval.getValue();
        this.status = status.getValue().intValue();
        this.agreeVoters = agreeVoters.getValue().stream().map(Address::getValue).collect(Collectors.toList());
        this.againstVoters = againstVoters.getValue().stream().map(Address::getValue).collect(Collectors.toList());
    }

    public ProposalInfo(String resourceId, String proposer, int proposalType, BigInteger blockNumberInterval, int status, List<String> agreeVoters, List<String> againstVoters) {
        super(new Type[]{new Address(resourceId), new Address(proposer), new Uint8(proposalType), new Uint256(blockNumberInterval), new Uint8(status), new DynamicArray<Address>(Address.class, agreeVoters.stream().map(Address::new).collect(Collectors.toList())), new DynamicArray<Address>(Address.class, againstVoters.stream().map(Address::new).collect(Collectors.toList()))});
        this.resourceId = resourceId;
        this.proposer = proposer;
        this.proposalType = proposalType;
        this.blockNumberInterval = blockNumberInterval;
        this.status = status;
        this.agreeVoters = agreeVoters;
        this.againstVoters = againstVoters;
    }

    public ProposalInfo(Tuple7<String, String, BigInteger, BigInteger, BigInteger, List<String>, List<String>> tuple7) {
        super(new Type[]{new Address(tuple7.getValue1()), new Address(tuple7.getValue2()), new Uint8(tuple7.getValue3()), new Uint256(tuple7.getValue4()), new Uint8(tuple7.getValue5()), new DynamicArray<Address>(Address.class, tuple7.getValue6().stream().map(Address::new).collect(Collectors.toList())), new DynamicArray<Address>(Address.class, tuple7.getValue7().stream().map(Address::new).collect(Collectors.toList()))});
        this.resourceId = tuple7.getValue1();
        this.proposer = tuple7.getValue2();
        this.proposalType = tuple7.getValue3().intValue();
        this.blockNumberInterval = tuple7.getValue4();
        this.status = tuple7.getValue5().intValue();
        this.agreeVoters = tuple7.getValue6();
        this.againstVoters = tuple7.getValue7();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getProposer() {
        return this.proposer;
    }

    public void setProposer(String proposer) {
        this.proposer = proposer;
    }

    public int getProposalType() {
        return this.proposalType;
    }

    public String getProposalTypeString() {
        return ProposalType.fromInt(this.proposalType).getValue();
    }

    public void setProposalType(int proposalType) {
        this.proposalType = proposalType;
    }

    public BigInteger getBlockNumberInterval() {
        return this.blockNumberInterval;
    }

    public void setBlockNumberInterval(BigInteger blockNumberInterval) {
        this.blockNumberInterval = blockNumberInterval;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        return ProposalStatus.fromInt(this.status).getValue();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<String> getAgreeVoters() {
        return this.agreeVoters;
    }

    public void setAgreeVoters(List<String> agreeVoters) {
        this.agreeVoters = agreeVoters;
    }

    public List<String> getAgainstVoters() {
        return this.againstVoters;
    }

    public void setAgainstVoters(List<String> againstVoters) {
        this.againstVoters = againstVoters;
    }

    public String toString() {
        return "ProposalInfo{resourceId='" + this.resourceId + '\'' + ", proposer='" + this.proposer + '\'' + ", proposalType=" + ProposalType.fromInt(this.proposalType).getValue() + ", blockNumberInterval=" + this.blockNumberInterval + ", status=" + ProposalStatus.fromInt(this.status).getValue() + ", agreeVoters=" + this.agreeVoters + ", againstVoters=" + this.againstVoters + '}';
    }
}

