/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.auth.po;

import java.math.BigInteger;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;

public enum AuthType {
    NO_ACL(0),
    WHITE_LIST(1),
    BLACK_LIST(2);

    private final int value;

    private AuthType(int i) {
        this.value = i;
    }

    public static AuthType valueOf(int i) throws ContractException {
        switch (i) {
            case 0: {
                return NO_ACL;
            }
            case 1: {
                return WHITE_LIST;
            }
            case 2: {
                return BLACK_LIST;
            }
        }
        throw new ContractException("Error Auth Type:" + i);
    }

    public final BigInteger getValue() {
        return BigInteger.valueOf(this.value);
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return "NO_ACL";
            }
            case 1: {
                return "WHITE_LIST";
            }
            case 2: {
                return "BLACK_LIST";
            }
        }
        return "UNKNOWN";
    }
}

