/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.auth.manager;

import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.tuples.generated.Tuple3;
import org.fisco.bcos.sdk.v3.contract.auth.contracts.CommitteeManager;
import org.fisco.bcos.sdk.v3.contract.auth.contracts.ContractAuthPrecompiled;
import org.fisco.bcos.sdk.v3.contract.auth.po.AuthType;
import org.fisco.bcos.sdk.v3.contract.auth.po.CommitteeInfo;
import org.fisco.bcos.sdk.v3.contract.auth.po.ProposalInfo;
import org.fisco.bcos.sdk.v3.contract.precompiled.callback.PrecompiledCallback;
import org.fisco.bcos.sdk.v3.contract.precompiled.sysconfig.SystemConfigService;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.model.PrecompiledRetCode;
import org.fisco.bcos.sdk.v3.model.RetCode;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.TransactionReceiptStatus;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;

public class AuthManager {
    private final Client client;
    private final CommitteeManager committeeManager;
    private final ContractAuthPrecompiled contractAuthPrecompiled;
    private BigInteger DEFAULT_BLOCK_NUMBER_INTERVAL = BigInteger.valueOf(604800L);

    public AuthManager(Client client, CryptoKeyPair credential) {
        this.client = client;
        this.committeeManager = CommitteeManager.load("0000000000000000000000000000000000010001", client, credential);
        this.contractAuthPrecompiled = ContractAuthPrecompiled.load("0000000000000000000000000000000000001005", client, credential);
    }

    public AuthManager(Client client, CryptoKeyPair credential, BigInteger blockNumberInterval) {
        this(client, credential);
        this.DEFAULT_BLOCK_NUMBER_INTERVAL = blockNumberInterval;
    }

    public String getCommitteeAddress() throws ContractException {
        return this.committeeManager._committee();
    }

    public String getProposalManagerAddress() throws ContractException {
        return this.committeeManager._proposalMgr();
    }

    public BigInteger updateGovernor(String account, BigInteger weight) throws ContractException {
        TransactionReceipt tr = this.committeeManager.createUpdateGovernorProposal(account, weight, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        return this.committeeManager.getCreateUpdateGovernorProposalOutput(tr).getValue1();
    }

    public BigInteger setRate(BigInteger participatesRate, BigInteger winRate) throws ContractException {
        TransactionReceipt tr = this.committeeManager.createSetRateProposal(participatesRate, winRate, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        return this.committeeManager.getCreateSetRateProposalOutput(tr).getValue1();
    }

    public BigInteger setDeployAuthType(AuthType deployAuthType) throws ContractException {
        TransactionReceipt tr = this.committeeManager.createSetDeployAuthTypeProposal(deployAuthType.getValue(), this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        BigInteger proposalId = this.committeeManager.getCreateSetDeployAuthTypeProposalOutput(tr).getValue1();
        this.getExecEvent(tr, proposalId);
        return proposalId;
    }

    public BigInteger getDeployAuthType() throws ContractException {
        return this.contractAuthPrecompiled.deployType();
    }

    public BigInteger modifyDeployAuth(String account, Boolean openFlag) throws ContractException {
        TransactionReceipt tr = this.committeeManager.createModifyDeployAuthProposal(account, openFlag, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        BigInteger proposalId = this.committeeManager.getCreateModifyDeployAuthProposalOutput(tr).getValue1();
        this.getExecEvent(tr, proposalId);
        return proposalId;
    }

    public BigInteger resetAdmin(String newAdmin, String contractAddr) throws ContractException {
        TransactionReceipt tr = this.committeeManager.createResetAdminProposal(newAdmin, contractAddr, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        BigInteger proposalId = this.committeeManager.getCreateResetAdminProposalOutput(tr).getValue1();
        this.getExecEvent(tr, proposalId);
        return proposalId;
    }

    public BigInteger createRmNodeProposal(String node) throws ContractException {
        TransactionReceipt tr = this.committeeManager.createRmNodeProposal(node, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        BigInteger proposalId = this.committeeManager.getCreateRmNodeProposalOutput(tr).getValue1();
        this.getExecEvent(tr, proposalId);
        return proposalId;
    }

    public BigInteger createSetConsensusWeightProposal(String node, BigInteger weight, boolean addFlag) throws ContractException {
        weight = weight.compareTo(BigInteger.ZERO) < 0 ? BigInteger.ZERO : weight;
        this.checkSetConsensusWeightParams(node, weight, addFlag);
        TransactionReceipt tr = this.committeeManager.createSetConsensusWeightProposal(node, weight, addFlag, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        BigInteger proposalId = this.committeeManager.getCreateSetConsensusWeightProposalOutput(tr).getValue1();
        this.getExecEvent(tr, proposalId);
        return proposalId;
    }

    private void checkSetConsensusWeightParams(String node, BigInteger weight, boolean addFlag) throws ContractException {
        if (addFlag) {
            boolean existence;
            if (!this.existsInNodeList(node)) {
                throw new ContractException("The operated node must be in the list returned by getGroupPeers");
            }
            boolean bl = existence = weight.compareTo(BigInteger.ZERO) > 0 ? ((List)this.client.getSealerList().getResult()).stream().anyMatch(sealer -> sealer.getNodeID().equals(node)) : ((List)this.client.getObserverList().getResult()).contains(node);
            if (existence) {
                throw new ContractException(weight.compareTo(BigInteger.ZERO) > 0 ? "The node already exists in the sealerList" : "The node already exists in the observerList");
            }
        } else if (weight.compareTo(BigInteger.ZERO) <= 0) {
            throw new ContractException(PrecompiledRetCode.CODE_INVALID_WEIGHT.getMessage());
        }
    }

    public BigInteger createSetSysConfigProposal(String key, String value) throws ContractException {
        if (!SystemConfigService.checkSysNumberValueValidation(key, value)) {
            throw new ContractException("Invalid value \"" + value + "\" for " + key + ", please check valid range.");
        }
        TransactionReceipt tr = this.committeeManager.createSetSysConfigProposal(key, value, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        BigInteger proposalId = this.committeeManager.getCreateSetSysConfigProposalOutput(tr).getValue1();
        this.getExecEvent(tr, proposalId);
        return proposalId;
    }

    public BigInteger createUpgradeVoteComputerProposal(String address) throws ContractException {
        TransactionReceipt tr = this.committeeManager.createUpgradeVoteComputerProposal(address, this.DEFAULT_BLOCK_NUMBER_INTERVAL);
        if (tr.getStatus() != TransactionReceiptStatus.Success.code) {
            ReceiptParser.getErrorStatus(tr);
        }
        return this.committeeManager.getCreateUpgradeVoteComputerProposalOutput(tr).getValue1();
    }

    public TransactionReceipt revokeProposal(BigInteger proposalId) {
        return this.committeeManager.revokeProposal(proposalId);
    }

    public void asyncRevokeProposal(BigInteger proposalId, TransactionCallback callback) {
        this.committeeManager.revokeProposal(proposalId, callback);
    }

    public TransactionReceipt voteProposal(BigInteger proposalId, Boolean agree) {
        return this.committeeManager.voteProposal(proposalId, agree);
    }

    public void asyncVoteProposal(BigInteger proposalId, Boolean agree, TransactionCallback callback) {
        this.committeeManager.voteProposal(proposalId, agree, callback);
    }

    public ProposalInfo getProposalInfo(BigInteger proposalId) throws ContractException {
        return new ProposalInfo(this.committeeManager.getProposalManager().getProposalInfo(proposalId));
    }

    public List<ProposalInfo> getProposalInfoList(BigInteger from, BigInteger to) throws ContractException {
        return this.committeeManager.getProposalManager().getProposalInfoList(from, to);
    }

    public CommitteeInfo getCommitteeInfo() throws ContractException {
        return new CommitteeInfo().fromTuple(this.committeeManager.getCommittee().getCommitteeInfo());
    }

    public Boolean checkDeployAuth(String account) throws ContractException {
        return this.contractAuthPrecompiled.hasDeployAuth(account);
    }

    public Boolean checkMethodAuth(String contractAddress, byte[] func, String account) throws ContractException {
        return this.contractAuthPrecompiled.checkMethodAuth(contractAddress, func, account);
    }

    public Tuple3<AuthType, List<String>, List<String>> getMethodAuth(String contractAddress, byte[] func) throws ContractException {
        Tuple3<BigInteger, List<String>, List<String>> methodAuth = this.contractAuthPrecompiled.getMethodAuth(contractAddress, func);
        AuthType authType = AuthType.valueOf(methodAuth.getValue1().intValue());
        return new Tuple3<AuthType, List<String>, List<String>>(authType, methodAuth.getValue2(), methodAuth.getValue3());
    }

    public String getAdmin(String contractAddress) throws ContractException {
        return this.contractAuthPrecompiled.getAdmin(contractAddress);
    }

    public RetCode setMethodAuthType(String contractAddress, byte[] func, AuthType authType) throws ContractException {
        TransactionReceipt transactionReceipt = this.contractAuthPrecompiled.setMethodAuthType(contractAddress, func, authType.getValue());
        return ReceiptParser.parseTransactionReceipt(transactionReceipt, tr -> this.contractAuthPrecompiled.getSetMethodAuthTypeOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncSetMethodAuthType(String contractAddress, byte[] func, AuthType authType, PrecompiledCallback callback) {
        this.contractAuthPrecompiled.setMethodAuthType(contractAddress, func, authType.getValue(), this.createTransactionCallback(callback, tr -> this.contractAuthPrecompiled.getSetMethodAuthTypeOutput((TransactionReceipt)tr).getValue1()));
    }

    public RetCode setMethodAuth(String contractAddress, byte[] func, String account, boolean isOpen) throws ContractException {
        TransactionReceipt receipt = isOpen ? this.contractAuthPrecompiled.openMethodAuth(contractAddress, func, account) : this.contractAuthPrecompiled.closeMethodAuth(contractAddress, func, account);
        return ReceiptParser.parseTransactionReceipt(receipt, tr -> isOpen ? this.contractAuthPrecompiled.getOpenMethodAuthOutput((TransactionReceipt)tr).getValue1() : this.contractAuthPrecompiled.getCloseMethodAuthOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncSetMethodAuth(String contractAddress, byte[] func, String account, boolean isOpen, PrecompiledCallback callback) {
        if (isOpen) {
            this.contractAuthPrecompiled.openMethodAuth(contractAddress, func, account, this.createTransactionCallback(callback, tr -> this.contractAuthPrecompiled.getOpenMethodAuthOutput((TransactionReceipt)tr).getValue1()));
        } else {
            this.contractAuthPrecompiled.closeMethodAuth(contractAddress, func, account, this.createTransactionCallback(callback, tr -> this.contractAuthPrecompiled.getCloseMethodAuthOutput((TransactionReceipt)tr).getValue1()));
        }
    }

    public RetCode setContractStatus(String contractAddress, boolean isFreeze) throws ContractException {
        TransactionReceipt transactionReceipt = this.contractAuthPrecompiled.setContractStatus(contractAddress, isFreeze);
        return ReceiptParser.parseTransactionReceipt(transactionReceipt, tr -> this.contractAuthPrecompiled.getSetContractStatusOutput((TransactionReceipt)tr).getValue1());
    }

    public void asyncSetContractStatus(String contractAddress, boolean isFreeze, PrecompiledCallback callback) {
        this.contractAuthPrecompiled.setContractStatus(contractAddress, isFreeze, this.createTransactionCallback(callback, tr -> this.contractAuthPrecompiled.getSetContractStatusOutput((TransactionReceipt)tr).getValue1()));
    }

    public Boolean contractAvailable(String contractAddress) throws ContractException {
        return this.contractAuthPrecompiled.contractAvailable(contractAddress);
    }

    public BigInteger proposalCount() throws ContractException {
        return this.committeeManager.getProposalManager()._proposalCount();
    }

    private boolean existsInNodeList(String nodeId) {
        List<String> nodeIdList = this.client.getGroupPeers().getGroupPeers();
        return nodeIdList.contains(nodeId);
    }

    private TransactionCallback createTransactionCallback(final PrecompiledCallback callback, final Function<TransactionReceipt, BigInteger> resultCaller) {
        return new TransactionCallback(){

            @Override
            public void onResponse(TransactionReceipt receipt) {
                RetCode retCode;
                try {
                    retCode = AuthManager.this.getCurdRetCode(receipt, resultCaller);
                }
                catch (ContractException e) {
                    retCode = new RetCode(e.getErrorCode(), e.getMessage());
                    retCode.setTransactionReceipt(receipt);
                }
                callback.onResponse(retCode);
            }
        };
    }

    private RetCode getCurdRetCode(TransactionReceipt transactionReceipt, Function<TransactionReceipt, BigInteger> resultCaller) throws ContractException {
        int status = transactionReceipt.getStatus();
        if (status != 0) {
            ReceiptParser.getErrorStatus(transactionReceipt);
        }
        BigInteger result = resultCaller.apply(transactionReceipt);
        return PrecompiledRetCode.getPrecompiledResponse(result.intValue(), transactionReceipt.getMessage());
    }

    private void getExecEvent(TransactionReceipt tr, BigInteger proposalId) throws ContractException {
        BigInteger execResultParam0;
        List<CommitteeManager.ExecResultEventResponse> execResultEvents = this.committeeManager.getExecResultEvents(tr);
        if (!execResultEvents.isEmpty() && !BigInteger.ZERO.equals(execResultParam0 = execResultEvents.get((int)0).execResultParam0)) {
            RetCode precompiledResponse = PrecompiledRetCode.getPrecompiledResponse(execResultParam0.intValue(), "");
            throw new ContractException("Exec proposal finished with error occurs, proposalId: " + proposalId + ", exec error msg: " + precompiledResponse.getMessage(), precompiledResponse.getCode());
        }
    }
}

