/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.config.model;

import java.util.Map;
import org.fisco.bcos.sdk.v3.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.v3.config.model.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoMaterialConfig {
    private static final Logger logger = LoggerFactory.getLogger(CryptoMaterialConfig.class);
    private Boolean useSmCrypto = false;
    private Boolean disableSsl = false;
    private String certPath = "conf";
    private String caCertPath;
    private String sdkCertPath;
    private String sdkPrivateKeyPath;
    private String enSdkCertPath;
    private String enSdkPrivateKeyPath;
    private String caCert;
    private String sdkCert;
    private String sdkPrivateKey;
    private String enSdkCert;
    private String enSdkPrivateKey;

    public CryptoMaterialConfig() {
    }

    public CryptoMaterialConfig(ConfigProperty configProperty) throws ConfigException {
        Map<String, Object> cryptoMaterialProperty = configProperty.getCryptoMaterial();
        String useSMCrypto = (String)cryptoMaterialProperty.get("useSMCrypto");
        String disableSsl = (String)cryptoMaterialProperty.get("disableSsl");
        this.useSmCrypto = Boolean.valueOf(useSMCrypto);
        this.disableSsl = Boolean.valueOf(disableSsl);
        if (this.disableSsl.booleanValue()) {
            logger.info("Load cryptoMaterial, disableSsl has been set");
            return;
        }
        int cryptoType = this.useSmCrypto != false ? 1 : 0;
        this.certPath = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(cryptoMaterialProperty, "certPath", this.certPath));
        CryptoMaterialConfig defaultCryptoMaterialConfig = this.getDefaultCaCertPath(cryptoType, this.certPath);
        if (cryptoType == 0) {
            this.caCert = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "caCert", defaultCryptoMaterialConfig.getCaCertPath()));
            this.sdkCert = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "sslCert", defaultCryptoMaterialConfig.getSdkCertPath()));
            this.sdkPrivateKey = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "sslKey", defaultCryptoMaterialConfig.getSdkPrivateKeyPath()));
        } else {
            this.caCert = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "caCert", defaultCryptoMaterialConfig.getCaCertPath()));
            this.sdkCert = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "sslCert", defaultCryptoMaterialConfig.getSdkCertPath()));
            this.sdkPrivateKey = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "sslKey", defaultCryptoMaterialConfig.getSdkPrivateKeyPath()));
            this.enSdkCert = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "enSslCert", defaultCryptoMaterialConfig.getEnSdkCertPath()));
            this.enSdkPrivateKey = ConfigProperty.getConfigFileContent(ConfigProperty.getValue(cryptoMaterialProperty, "enSslKey", defaultCryptoMaterialConfig.getEnSdkPrivateKeyPath()));
        }
        logger.debug("Load cryptoMaterial, useSmCrypto: {}, caCertPath: {}, sdkCertPath: {}, sdkPrivateKeyPath:{}, enSSLCertPath: {}, enSSLPrivateKeyPath:{}", new Object[]{this.useSmCrypto, this.getCaCertPath(), this.getSdkCertPath(), this.getSdkPrivateKeyPath(), this.getEnSdkCertPath(), this.getEnSdkPrivateKeyPath()});
    }

    public CryptoMaterialConfig getDefaultCaCertPath(int cryptoType, String certPath) throws ConfigException {
        CryptoMaterialConfig cryptoMaterialConfig = new CryptoMaterialConfig();
        cryptoMaterialConfig.setCertPath(certPath);
        if (cryptoType == 0) {
            cryptoMaterialConfig.setCaCertPath(certPath + "/ca.crt");
            cryptoMaterialConfig.setSdkCertPath(certPath + "/sdk.crt");
            cryptoMaterialConfig.setSdkPrivateKeyPath(certPath + "/sdk.key");
        } else if (cryptoType == 1) {
            cryptoMaterialConfig.setCaCertPath(certPath + "/sm_ca.crt");
            cryptoMaterialConfig.setSdkCertPath(certPath + "/sm_sdk.crt");
            cryptoMaterialConfig.setSdkPrivateKeyPath(certPath + "/sm_sdk.key");
            cryptoMaterialConfig.setEnSdkCertPath(certPath + "/sm_ensdk.crt");
            cryptoMaterialConfig.setEnSdkPrivateKeyPath(certPath + "/sm_ensdk.key");
        } else {
            throw new ConfigException("load CryptoMaterialConfig failed, only support ecdsa and sm now, expected 0 or 1, but provided " + cryptoType);
        }
        return cryptoMaterialConfig;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public String getSdkCert() {
        return this.sdkCert;
    }

    public void setSdkCert(String sdkCert) {
        this.sdkCert = sdkCert;
    }

    public String getSdkPrivateKey() {
        return this.sdkPrivateKey;
    }

    public void setSdkPrivateKey(String sdkPrivateKey) {
        this.sdkPrivateKey = sdkPrivateKey;
    }

    public String getEnSdkCert() {
        return this.enSdkCert;
    }

    public void setEnSdkCert(String enSdkCert) {
        this.enSdkCert = enSdkCert;
    }

    public String getEnSdkPrivateKey() {
        return this.enSdkPrivateKey;
    }

    public void setEnSdkPrivateKey(String enSdkPrivateKey) {
        this.enSdkPrivateKey = enSdkPrivateKey;
    }

    public Boolean getUseSmCrypto() {
        return this.useSmCrypto;
    }

    public Boolean getDisableSsl() {
        return this.disableSsl;
    }

    public void setDisableSsl(Boolean disableSsl) {
        this.disableSsl = disableSsl;
    }

    public void setUseSmCrypto(Boolean useSmCrypto) {
        this.useSmCrypto = useSmCrypto;
    }

    public int getSslCryptoType() {
        return this.useSmCrypto != false ? 1 : 0;
    }

    public boolean isUseSmCrypto() {
        return this.useSmCrypto;
    }

    public String getCaCertPath() {
        return this.caCertPath;
    }

    public void setCaCertPath(String caCertPath) {
        this.caCertPath = caCertPath;
    }

    public String getSdkCertPath() {
        return this.sdkCertPath;
    }

    public void setSdkCertPath(String sdkCertPath) {
        this.sdkCertPath = sdkCertPath;
    }

    public String getSdkPrivateKeyPath() {
        return this.sdkPrivateKeyPath;
    }

    public void setSdkPrivateKeyPath(String sdkPrivateKeyPath) {
        this.sdkPrivateKeyPath = sdkPrivateKeyPath;
    }

    public String getEnSdkCertPath() {
        return this.enSdkCertPath;
    }

    public void setEnSdkCertPath(String enSdkCertPath) {
        this.enSdkCertPath = enSdkCertPath;
    }

    public String getEnSdkPrivateKeyPath() {
        return this.enSdkPrivateKeyPath;
    }

    public void setEnSdkPrivateKeyPath(String enSdkPrivateKeyPath) {
        this.enSdkPrivateKeyPath = enSdkPrivateKeyPath;
    }

    public String toString() {
        return "CryptoMaterialConfig{useSmCrypto=" + this.useSmCrypto + ", certPath='" + this.certPath + '\'' + ", caCertPath='" + this.caCertPath + '\'' + ", sdkCertPath='" + this.sdkCertPath + '\'' + ", sdkPrivateKeyPath='" + this.sdkPrivateKeyPath + '\'' + ", enSdkCertPath='" + this.enSdkCertPath + '\'' + ", enSdkPrivateKeyPath='" + this.enSdkPrivateKeyPath + '\'' + '}';
    }
}

