/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.config.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.fisco.bcos.sdk.v3.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.v3.config.model.AmopTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigProperty {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProperty.class);
    public Map<String, Object> cryptoMaterial;
    public Map<String, Object> network;
    public List<AmopTopic> amop;
    public Map<String, Object> account;
    public Map<String, Object> threadPool;

    public Map<String, Object> getCryptoMaterial() {
        return this.cryptoMaterial;
    }

    public void setCryptoMaterial(Map<String, Object> cryptoMaterial) {
        this.cryptoMaterial = cryptoMaterial;
    }

    public Map<String, Object> getNetwork() {
        return this.network;
    }

    public void setNetwork(Map<String, Object> network) {
        this.network = network;
    }

    public List<AmopTopic> getAmop() {
        return this.amop;
    }

    public void setAmop(List<AmopTopic> amop) {
        this.amop = amop;
    }

    public Map<String, Object> getAccount() {
        return this.account;
    }

    public void setAccount(Map<String, Object> account) {
        this.account = account;
    }

    public Map<String, Object> getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(Map<String, Object> threadPool) {
        this.threadPool = threadPool;
    }

    public static String getValue(Map<String, Object> config, String key, String defaultValue) {
        if (config == null || config.get(key) == null) {
            return defaultValue;
        }
        return (String)config.get(key);
    }

    public static String getConfigFilePath(String configFilePath) throws ConfigException {
        try {
            if (configFilePath == null) {
                return null;
            }
            File file = new File(configFilePath);
            if (file.exists()) {
                return configFilePath;
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(configFilePath);
            if (url == null) {
                return configFilePath;
            }
            String resourceCertPath = URLDecoder.decode(url.getPath(), "utf-8");
            if (new File(resourceCertPath).exists()) {
                return resourceCertPath;
            }
            return configFilePath;
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getConfigFileContent(String configFilePath) throws ConfigException {
        try {
            File file = new File(configFilePath);
            if (file.exists()) {
                Path path = file.toPath();
                return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            }
            try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFilePath);){
                if (Objects.isNull(in)) {
                    throw new ConfigException("File not found, path: " + configFilePath);
                }
                String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (Exception e) {
            logger.warn("e: ", (Throwable)e);
            throw new ConfigException("File not found, path: " + configFilePath);
        }
    }
}

