/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.fisco.bcos.sdk.jni.common.JniConfig;
import org.fisco.bcos.sdk.v3.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.v3.config.model.AccountConfig;
import org.fisco.bcos.sdk.v3.config.model.AmopConfig;
import org.fisco.bcos.sdk.v3.config.model.ConfigProperty;
import org.fisco.bcos.sdk.v3.config.model.CryptoMaterialConfig;
import org.fisco.bcos.sdk.v3.config.model.NetworkConfig;
import org.fisco.bcos.sdk.v3.config.model.ThreadPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigOption {
    private static final Logger logger = LoggerFactory.getLogger(ConfigOption.class);
    private static boolean DISABLE_SSL = false;
    private CryptoMaterialConfig cryptoMaterialConfig;
    private AccountConfig accountConfig;
    private AmopConfig amopConfig;
    private NetworkConfig networkConfig;
    private ThreadPoolConfig threadPoolConfig;
    private ConfigProperty configProperty;
    private JniConfig jniConfig;

    public ConfigOption() {
    }

    public ConfigOption(ConfigProperty configProperty) throws ConfigException {
        this.cryptoMaterialConfig = new CryptoMaterialConfig(configProperty);
        this.accountConfig = new AccountConfig(configProperty);
        this.amopConfig = new AmopConfig(configProperty);
        this.networkConfig = new NetworkConfig(configProperty);
        this.threadPoolConfig = new ThreadPoolConfig(configProperty);
        this.jniConfig = this.generateJniConfig();
        this.configProperty = configProperty;
    }

    public void reloadConfig() throws ConfigException {
        this.cryptoMaterialConfig = new CryptoMaterialConfig(this.configProperty);
    }

    public JniConfig generateJniConfig() {
        JniConfig jniConfig = new JniConfig();
        jniConfig.setPeers(this.networkConfig.getPeers());
        boolean disableSsl = DISABLE_SSL;
        if (!disableSsl) {
            disableSsl = this.cryptoMaterialConfig.getDisableSsl();
        }
        jniConfig.setDisableSsl(disableSsl);
        jniConfig.setThreadPoolSize(this.threadPoolConfig.getThreadPoolSize());
        jniConfig.setMessageTimeoutMs(this.networkConfig.getTimeout());
        if (disableSsl) {
            logger.info(" ==>> java sdk work in disable ssl model !!!");
            return jniConfig;
        }
        if (this.cryptoMaterialConfig.getUseSmCrypto().booleanValue()) {
            JniConfig.SMCertConfig smCertConfig = new JniConfig.SMCertConfig();
            smCertConfig.setCaCert(this.cryptoMaterialConfig.getCaCert());
            smCertConfig.setNodeCert(this.cryptoMaterialConfig.getSdkCert());
            smCertConfig.setNodeKey(this.cryptoMaterialConfig.getSdkPrivateKey());
            smCertConfig.setEnNodeCert(this.cryptoMaterialConfig.getEnSdkCert());
            smCertConfig.setEnNodeKey(this.cryptoMaterialConfig.getEnSdkPrivateKey());
            jniConfig.setSslType("sm_ssl");
            jniConfig.setSmCertConfig(smCertConfig);
        } else {
            JniConfig.CertConfig certConfig = new JniConfig.CertConfig();
            certConfig.setCaCert(this.cryptoMaterialConfig.getCaCert());
            certConfig.setNodeCert(this.cryptoMaterialConfig.getSdkCert());
            certConfig.setNodeKey(this.cryptoMaterialConfig.getSdkPrivateKey());
            jniConfig.setCertConfig(certConfig);
            jniConfig.setSslType("ssl");
        }
        return jniConfig;
    }

    public CryptoMaterialConfig getCryptoMaterialConfig() {
        return this.cryptoMaterialConfig;
    }

    public void setCryptoMaterialConfig(CryptoMaterialConfig cryptoMaterialConfig) {
        this.cryptoMaterialConfig = cryptoMaterialConfig;
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }

    public void setAccountConfig(AccountConfig accountConfig) {
        this.accountConfig = accountConfig;
    }

    public AmopConfig getAmopConfig() {
        return this.amopConfig;
    }

    public void setAmopConfig(AmopConfig amopConfig) {
        this.amopConfig = amopConfig;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public void setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public ThreadPoolConfig getThreadPoolConfig() {
        return this.threadPoolConfig;
    }

    public void setThreadPoolConfig(ThreadPoolConfig threadPoolConfig) {
        this.threadPoolConfig = threadPoolConfig;
    }

    public JniConfig getJniConfig() {
        return this.jniConfig;
    }

    public void setJniConfig(JniConfig jniConfig) {
        this.jniConfig = jniConfig;
    }

    public ConfigProperty getConfigProperty() {
        return this.configProperty;
    }

    public void setConfigProperty(ConfigProperty configProperty) {
        this.configProperty = configProperty;
    }

    static {
        String value = System.getProperty("org.fisco.bcos.jni.disableSsl");
        if (value != null) {
            DISABLE_SSL = "true".equals(value);
            logger.info("-Dorg.fisco.bcos.jni.disableSsl is set, value: {}", (Object)value);
        }
    }
}

