/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.wrapper;

import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIObject;
import org.fisco.bcos.sdk.v3.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABIObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(ABIObjectFactory.class);

    public static ABIObject createInputObject(ABIDefinition abiDefinition) {
        return ABIObjectFactory.createObject(abiDefinition.getName(), abiDefinition.getInputs());
    }

    public static ABIObject createOutputObject(ABIDefinition abiDefinition) {
        return ABIObjectFactory.createObject(abiDefinition.getName(), abiDefinition.getOutputs());
    }

    private static ABIObject createObject(String name, List<ABIDefinition.NamedType> namedTypes) {
        try {
            ABIObject abiObject = new ABIObject(ABIObject.ObjectType.STRUCT);
            for (ABIDefinition.NamedType namedType : namedTypes) {
                abiObject.getStructFields().add(ABIObjectFactory.buildTypeObject(namedType));
            }
            logger.info(" name: {}", (Object)name);
            return abiObject;
        }
        catch (Exception e) {
            logger.error("namedTypes: {},  e: ", namedTypes, (Object)e);
            return null;
        }
    }

    public static ABIObject createEventInputObject(ABIDefinition abiDefinition) {
        return ABIObjectFactory.creatEventObjectWithOutIndexed(abiDefinition.getInputs());
    }

    public static ABIObject creatEventObjectWithOutIndexed(List<ABIDefinition.NamedType> namedTypes) {
        try {
            ABIObject abiObject = new ABIObject(ABIObject.ObjectType.STRUCT);
            for (ABIDefinition.NamedType namedType : namedTypes) {
                if (namedType.isIndexed()) continue;
                abiObject.getStructFields().add(ABIObjectFactory.buildTypeObject(namedType));
            }
            return abiObject;
        }
        catch (Exception e) {
            logger.error("namedTypes: {},  e: ", namedTypes, (Object)e);
            return null;
        }
    }

    public static ABIObject buildRawTypeObject(String rawType) {
        ABIObject abiObject = null;
        if (rawType.startsWith("uint")) {
            abiObject = new ABIObject(ABIObject.ValueType.UINT);
        } else if (rawType.startsWith("int")) {
            abiObject = new ABIObject(ABIObject.ValueType.INT);
        } else if (rawType.startsWith("bool")) {
            abiObject = new ABIObject(ABIObject.ValueType.BOOL);
        } else if (rawType.startsWith("string")) {
            abiObject = new ABIObject(ABIObject.ValueType.STRING);
        } else if (rawType.equals("bytes")) {
            abiObject = new ABIObject(ABIObject.ValueType.DBYTES);
        } else if (rawType.startsWith("bytes")) {
            try {
                BigInteger bytesLength = Numeric.decodeQuantity(rawType.substring("bytes".length()));
                abiObject = new ABIObject(ABIObject.ValueType.BYTES, bytesLength.intValue());
            }
            catch (Exception e) {
                abiObject = new ABIObject(ABIObject.ValueType.BYTES);
            }
        } else if (rawType.startsWith("address")) {
            abiObject = new ABIObject(ABIObject.ValueType.ADDRESS);
        } else {
            if (rawType.startsWith("fixed") || rawType.startsWith("ufixed")) {
                throw new UnsupportedOperationException("Unsupported type:" + rawType);
            }
            throw new UnsupportedOperationException("Unrecognized type:" + rawType);
        }
        return abiObject;
    }

    private static ABIObject buildTupleObject(ABIDefinition.NamedType namedType) {
        return ABIObjectFactory.createObject(namedType.getName(), namedType.getComponents());
    }

    private static ABIObject buildListObject(ABIDefinition.Type typeObj, ABIDefinition.NamedType namedType) {
        ABIObject abiObject = null;
        if (typeObj.isList()) {
            ABIObject listObject = new ABIObject(ABIObject.ObjectType.LIST);
            listObject.setListType(typeObj.isFixedList() ? ABIObject.ListType.FIXED : ABIObject.ListType.DYNAMIC);
            if (typeObj.isFixedList()) {
                listObject.setListLength(typeObj.getLastDimension());
            }
            listObject.setListValueType(ABIObjectFactory.buildListObject(typeObj.reduceDimensionAndGetType(), namedType));
            abiObject = listObject;
        } else {
            abiObject = typeObj.getRawType().startsWith("tuple") ? ABIObjectFactory.buildTupleObject(namedType) : ABIObjectFactory.buildRawTypeObject(typeObj.getRawType());
        }
        return abiObject;
    }

    public static ABIObject buildTypeObject(ABIDefinition.NamedType namedType) {
        try {
            String type = namedType.getType();
            ABIDefinition.Type typeObj = new ABIDefinition.Type(type);
            String rawType = typeObj.getRawType();
            ABIObject abiObject = typeObj.isList() ? ABIObjectFactory.buildListObject(typeObj, namedType) : (rawType.startsWith("tuple") ? ABIObjectFactory.buildTupleObject(namedType) : ABIObjectFactory.buildRawTypeObject(rawType));
            abiObject.setName(namedType.getName());
            return abiObject;
        }
        catch (Exception e) {
            logger.error(" e: ", (Throwable)e);
            return null;
        }
    }
}

