/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.wrapper;

import org.fisco.bcos.sdk.v3.codec.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.v3.codec.wrapper.ContractABIDefinition;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABIDefinitionFactory {
    private static final Logger logger = LoggerFactory.getLogger(ABIDefinitionFactory.class);
    private CryptoSuite cryptoSuite;

    public ABIDefinitionFactory(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public ContractABIDefinition loadABI(String abi) {
        try {
            ABIDefinition[] abiDefinitions = (ABIDefinition[])ObjectMapperFactory.getObjectMapper().readValue(abi, ABIDefinition[].class);
            ContractABIDefinition contractABIDefinition = new ContractABIDefinition(this.cryptoSuite);
            for (ABIDefinition abiDefinition : abiDefinitions) {
                if (abiDefinition.getType().equals("constructor")) {
                    contractABIDefinition.setConstructor(abiDefinition);
                } else if (abiDefinition.getType().equals("function")) {
                    contractABIDefinition.addFunction(abiDefinition.getName(), abiDefinition);
                } else if (abiDefinition.getType().equals("event")) {
                    contractABIDefinition.addEvent(abiDefinition.getName(), abiDefinition);
                }
                logger.debug(" abiDefinition: {}", (Object)abiDefinition);
            }
            if (contractABIDefinition.getConstructor() == null) {
                contractABIDefinition.setConstructor(ABIDefinition.createDefaultConstructorABIDefinition());
            }
            logger.debug(" contractABIDefinition {} ", (Object)contractABIDefinition);
            return contractABIDefinition;
        }
        catch (Exception e) {
            logger.error(" e: ", (Throwable)e);
            return null;
        }
    }
}

