/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.scale;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.fisco.bcos.sdk.v3.codec.Utils;
import org.fisco.bcos.sdk.v3.codec.datatypes.AbiTypes;
import org.fisco.bcos.sdk.v3.codec.datatypes.Address;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bool;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.BytesType;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.Fixed;
import org.fisco.bcos.sdk.v3.codec.datatypes.FixedPointType;
import org.fisco.bcos.sdk.v3.codec.datatypes.Int;
import org.fisco.bcos.sdk.v3.codec.datatypes.IntType;
import org.fisco.bcos.sdk.v3.codec.datatypes.NumericType;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.StructType;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Ufixed;
import org.fisco.bcos.sdk.v3.codec.datatypes.Uint;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Uint160;
import org.fisco.bcos.sdk.v3.codec.scale.ScaleCodecReader;
import org.fisco.bcos.sdk.v3.utils.Hex;

public class TypeDecoder {
    public static <T extends Type> T decode(ScaleCodecReader reader, TypeReference<T> typeReference) throws ClassNotFoundException {
        Class<T> type = typeReference.getClassType();
        if (NumericType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeNumeric(reader, type);
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeBool(reader);
        }
        if (Address.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeAddress(reader);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeStaticBytes(reader, type);
        }
        if (BytesType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeBytes(reader, type);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeUtf8String(reader);
        }
        if (StructType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeStruct(reader, typeReference);
        }
        if (DynamicArray.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeDynamicArray(reader, typeReference);
        }
        if (StaticArray.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeStaticArray(reader, typeReference);
        }
        throw new UnsupportedOperationException("Type cannot be decoded: " + type);
    }

    public static <T extends Type> T decode(byte[] input, TypeReference<T> typeReference) throws ClassNotFoundException {
        ScaleCodecReader scaleCodecReader = new ScaleCodecReader(input);
        return TypeDecoder.decode(scaleCodecReader, typeReference);
    }

    public static <T extends Type> T decode(String input, TypeReference<T> typeReference) throws ClassNotFoundException {
        return TypeDecoder.decode(Hex.decode(input), typeReference);
    }

    public static Address decodeAddress(ScaleCodecReader reader) {
        return new Address(TypeDecoder.decodeNumeric(reader, Uint160.class));
    }

    public static <T extends NumericType> T decodeNumeric(ScaleCodecReader reader, Class<T> type) {
        try {
            String[] splitName;
            String regex;
            int bitSize = 256;
            if (IntType.class.isAssignableFrom(type)) {
                regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
                splitName = type.getSimpleName().split(regex);
                if (splitName.length == 2) {
                    bitSize = Integer.parseInt(splitName[1]);
                }
            } else if (FixedPointType.class.isAssignableFrom(type)) {
                regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
                splitName = type.getSimpleName().split(regex);
                if (splitName.length == 2) {
                    String[] bitsCounts = splitName[1].split("x");
                    bitSize = Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
                }
            }
            int bytesSize = bitSize >> 3;
            boolean signedValue = !type.toString().contains("Uint");
            BigInteger value = bytesSize >= 1 && bytesSize <= 16 ? reader.decodeInteger(signedValue, bytesSize) : reader.decodeInt256();
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(value));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName() + ": " + e.getMessage(), e);
        }
    }

    public static Bool decodeBool(ScaleCodecReader reader) {
        boolean boolValue = reader.readBoolean();
        return new Bool(boolValue);
    }

    public static <T extends BytesType> T decodeBytes(ScaleCodecReader reader, Class<T> type) {
        try {
            byte[] bytes = reader.readByteArray();
            return (T)((BytesType)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    public static <T extends BytesType> T decodeStaticBytes(ScaleCodecReader reader, Class<T> type) {
        try {
            int size = Integer.parseInt(type.getTypeName().substring(type.getTypeName().lastIndexOf("Bytes") + "Bytes".length()));
            byte[] bytes = reader.readByteArray(size);
            return (T)((BytesType)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    public static Utf8String decodeUtf8String(ScaleCodecReader reader) {
        String string = reader.readString();
        return new Utf8String(string);
    }

    public static <T extends Type> T decodeArray(ScaleCodecReader reader, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer, Integer length) {
        int len = length == null ? reader.readCompact() : length.intValue();
        try {
            Class cls = Utils.getParameterizedTypeFromArray(typeReference);
            ArrayList elements = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                Object value = TypeDecoder.decode(reader, TypeReference.create(cls));
                elements.add(value);
            }
            String typeName = Utils.getSimpleTypeName(cls);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }

    public static <T extends Type> T decodeStaticArray(ScaleCodecReader reader, TypeReference<T> typeReference) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            try {
                Class<?> arrayClass = Class.forName("org.fisco.bcos.sdk.v3.codec.datatypes.generated.StaticArray" + elements.size());
                return (Type)arrayClass.getConstructor(List.class).newInstance(elements);
            }
            catch (ReflectiveOperationException e) {
                throw new UnsupportedOperationException(e);
            }
        };
        int length = Integer.parseInt(((ParameterizedType)typeReference.getType()).getRawType().getClass().getSimpleName().substring(StaticArray.class.getSimpleName().length()));
        return (T)TypeDecoder.decodeArray(reader, typeReference, function, length);
    }

    public static <T extends Type> T decodeDynamicArray(ScaleCodecReader reader, TypeReference<T> typeReference) {
        BiFunction<List, String, Type> function = (elements, typName) -> new DynamicArray<Type>(AbiTypes.getType(typName), (List<? extends Type>)elements);
        return (T)TypeDecoder.decodeArray(reader, typeReference, function, null);
    }

    public static <T extends Type> T decodeStruct(ScaleCodecReader reader, TypeReference<T> typeReference) {
        try {
            Class<T> classType = typeReference.getClassType();
            Constructor constructor = Arrays.stream(classType.getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom) && declaredConstructor.getParameterTypes().length > 0).findAny().orElseThrow(() -> new RuntimeException("TypeReferenced struct must contain a constructor with types that extend Type"));
            int length = constructor.getParameterCount();
            ArrayList elements = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                java.lang.reflect.Type genericParameterType = constructor.getGenericParameterTypes()[i];
                Object value = TypeDecoder.decode(reader, TypeReference.create(genericParameterType));
                elements.add(value);
            }
            constructor.setAccessible(true);
            return (T)((Type)constructor.newInstance(elements.toArray()));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }
}

