/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.scale;

import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.fisco.bcos.sdk.v3.codec.scale.ScaleReader;
import org.fisco.bcos.sdk.v3.codec.scale.reader.BoolReader;
import org.fisco.bcos.sdk.v3.codec.scale.reader.CompactUIntReader;
import org.fisco.bcos.sdk.v3.codec.scale.reader.UByteReader;

public class ScaleCodecReader {
    public static final UByteReader UBYTE = new UByteReader();
    public static final CompactUIntReader COMPACT_UINT = new CompactUIntReader();
    public static final BoolReader BOOL = new BoolReader();
    private final byte[] source;
    private int pos = 0;

    public ScaleCodecReader(byte[] source) {
        this.source = source;
    }

    public boolean hasNext() {
        return this.pos < this.source.length;
    }

    public boolean hasMore(int size) {
        if (size == 0) {
            return true;
        }
        return this.pos + size - 1 < this.source.length;
    }

    public byte readByte() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Cannot read " + this.pos + " of " + this.source.length);
        }
        return this.source[this.pos++];
    }

    public <T> T read(ScaleReader<T> scaleReader) {
        if (scaleReader == null) {
            throw new NullPointerException("ItemReader cannot be null");
        }
        return scaleReader.read(this);
    }

    public int readUByte() {
        return UBYTE.read(this);
    }

    public int readCompact() {
        return COMPACT_UINT.read(this);
    }

    public boolean readBoolean() {
        return BOOL.read(this);
    }

    public byte[] readByteArray() {
        int len = this.readCompact();
        return this.readByteArray(len);
    }

    public byte[] readByteArray(int len) {
        byte[] result = new byte[len];
        System.arraycopy(this.source, this.pos, result, 0, result.length);
        this.pos += len;
        return result;
    }

    public BigInteger decodeInteger(boolean signed, int bytesSize) {
        if (!this.hasMore(bytesSize)) {
            throw new UnsupportedOperationException("decodeInteger exception for not enough data");
        }
        byte[] resultBytes = this.readByteArray(bytesSize);
        ArrayUtils.reverse((byte[])resultBytes);
        BigInteger value = new BigInteger(resultBytes);
        if (value.compareTo(BigInteger.ZERO) < 0 && !signed) {
            BigInteger minOverflowUnsignedValue = BigInteger.valueOf(1 << bytesSize * 8);
            return value.add(minOverflowUnsignedValue);
        }
        return value;
    }

    public BigInteger decodeInt256() {
        if (!this.hasMore(32)) {
            throw new UnsupportedOperationException("decodeInt256 exception for not enough data");
        }
        byte[] data = this.readByteArray(32);
        return new BigInteger(data);
    }

    public String readString() {
        return new String(this.readByteArray());
    }
}

