/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.scale;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.FunctionEncoderInterface;
import org.fisco.bcos.sdk.v3.codec.datatypes.Function;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.scale.ScaleCodecWriter;
import org.fisco.bcos.sdk.v3.codec.scale.TypeEncoder;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;

public class FunctionEncoder
extends FunctionEncoderInterface {
    public FunctionEncoder(CryptoSuite cryptoSuite) {
        super(cryptoSuite);
    }

    @Override
    public byte[] encode(Function function) {
        List<Type> parameters = function.getInputParameters();
        String methodSignature = FunctionEncoder.buildMethodSignature(function.getName(), parameters);
        byte[] methodId = this.buildMethodId(methodSignature);
        return FunctionEncoder.encodeParameters(parameters, methodId);
    }

    public static byte[] encodeConstructor(List<Type> parameters) {
        return FunctionEncoder.encodeParameters(parameters, null);
    }

    public static byte[] encodeParameters(List<Type> parameters, byte[] methodID) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            ScaleCodecWriter writer = new ScaleCodecWriter(result);
            if (methodID != null) {
                result.write(methodID);
            }
            for (Type parameter : parameters) {
                TypeEncoder.encode(parameter, writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toByteArray();
    }
}

