/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.scale;

import java.math.BigInteger;

public enum CompactMode {
    SINGLE(0),
    TWO(1),
    FOUR(2),
    BIGINT(3);

    private static BigInteger MAX;
    private byte value;

    private CompactMode(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static CompactMode byValue(byte value) {
        if (value == CompactMode.SINGLE.value) {
            return SINGLE;
        }
        if (value == CompactMode.TWO.value) {
            return TWO;
        }
        if (value == CompactMode.FOUR.value) {
            return FOUR;
        }
        return BIGINT;
    }

    public static CompactMode forNumber(int number) {
        return CompactMode.forNumber((long)number);
    }

    public static CompactMode forNumber(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("Negative numbers are not supported");
        }
        if (number <= 63L) {
            return SINGLE;
        }
        if (number <= 16383L) {
            return TWO;
        }
        if (number <= 0x3FFFFFFFL) {
            return FOUR;
        }
        return BIGINT;
    }

    public static CompactMode forNumber(BigInteger number) {
        if (number.signum() < 0) {
            throw new IllegalArgumentException("Negative numbers are not supported");
        }
        if (number.compareTo(MAX) > 0) {
            throw new IllegalArgumentException("Numbers larger than 2**536-1 are not supported");
        }
        if (number.equals(BigInteger.ZERO)) {
            return SINGLE;
        }
        if (number.compareTo(BigInteger.valueOf(0x3FFFFFFFL)) > 0) {
            return BIGINT;
        }
        if (number.compareTo(BigInteger.valueOf(16383L)) > 0) {
            return FOUR;
        }
        if (number.compareTo(BigInteger.valueOf(63L)) > 0) {
            return TWO;
        }
        return SINGLE;
    }

    static {
        MAX = new BigInteger("2").pow(536).subtract(BigInteger.ONE);
    }
}

