/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.datatypes;

import java.lang.reflect.ParameterizedType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fisco.bcos.sdk.v3.codec.datatypes.AbiTypes;
import org.fisco.bcos.sdk.v3.codec.datatypes.Array;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;

public abstract class TypeReference<T extends Type>
implements Comparable<TypeReference<T>> {
    protected static Pattern ARRAY_SUFFIX = Pattern.compile("\\[(\\d*)]");
    private final java.lang.reflect.Type type;
    private final boolean indexed;

    protected TypeReference() {
        this(false);
    }

    protected TypeReference(boolean indexed) {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.indexed = indexed;
    }

    protected TypeReference(java.lang.reflect.Type type) {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = type;
        this.indexed = false;
    }

    @Override
    public int compareTo(TypeReference<T> o) {
        return 0;
    }

    public java.lang.reflect.Type getType() {
        return this.type;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Class<T> getClassType() throws ClassNotFoundException {
        java.lang.reflect.Type clsType = this.getType();
        if (clsType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)clsType).getRawType();
        }
        return Class.forName(clsType.getTypeName());
    }

    public static <T extends Type> TypeReference<T> create(Class<T> cls) {
        return TypeReference.create(cls, false);
    }

    public static <T extends Type> TypeReference<T> create(final Class<T> cls, boolean indexed) {
        return new TypeReference<T>(indexed){

            @Override
            public java.lang.reflect.Type getType() {
                return cls;
            }
        };
    }

    public static <T extends Type> TypeReference<T> create(java.lang.reflect.Type type) {
        return new TypeReference<T>(type){

            @Override
            public java.lang.reflect.Type getType() {
                return super.getType();
            }
        };
    }

    protected static Class<? extends Type> getAtomicTypeClass(String type) throws ClassNotFoundException {
        if (ARRAY_SUFFIX.matcher(type).find()) {
            throw new ClassNotFoundException("getAtomicTypeClass does not work with array types. See makeTypeReference()");
        }
        return AbiTypes.getType(type);
    }

    public static TypeReference makeTypeReference(String type, final boolean indexed) throws ClassNotFoundException {
        Matcher nextSquareBrackets = ARRAY_SUFFIX.matcher(type);
        if (!nextSquareBrackets.find()) {
            Class<Type> typeClass = TypeReference.getAtomicTypeClass(type);
            return TypeReference.create(typeClass, indexed);
        }
        int lastReadStringPosition = nextSquareBrackets.start();
        Class<Type> baseClass = TypeReference.getAtomicTypeClass(type.substring(0, lastReadStringPosition));
        TypeReference<Array> arrayWrappedType = TypeReference.create(baseClass, indexed);
        int len = type.length();
        while (lastReadStringPosition < len) {
            String arraySize = nextSquareBrackets.group(1);
            final TypeReference<DynamicArray> baseTr = arrayWrappedType;
            if (arraySize == null || arraySize.equals("")) {
                arrayWrappedType = new TypeReference<DynamicArray>(indexed){

                    @Override
                    public java.lang.reflect.Type getType() {
                        return new ParameterizedType(){

                            @Override
                            public java.lang.reflect.Type[] getActualTypeArguments() {
                                return new java.lang.reflect.Type[]{baseTr.getType()};
                            }

                            @Override
                            public java.lang.reflect.Type getRawType() {
                                return DynamicArray.class;
                            }

                            @Override
                            public java.lang.reflect.Type getOwnerType() {
                                return Class.class;
                            }
                        };
                    }
                };
            } else {
                int arraySizeInt = Integer.parseInt(arraySize);
                final Class arrayClass = arraySizeInt <= StaticArray.MAX_SIZE_OF_STATIC_ARRAY ? Class.forName("org.fisco.bcos.sdk.v3.codec.datatypes.generated.StaticArray" + arraySize) : StaticArray.class;
                arrayWrappedType = new StaticArrayTypeReference<StaticArray>(arraySizeInt){

                    @Override
                    public boolean isIndexed() {
                        return indexed;
                    }

                    @Override
                    public java.lang.reflect.Type getType() {
                        return new ParameterizedType(){

                            @Override
                            public java.lang.reflect.Type[] getActualTypeArguments() {
                                return new java.lang.reflect.Type[]{baseTr.getType()};
                            }

                            @Override
                            public java.lang.reflect.Type getRawType() {
                                return arrayClass;
                            }

                            @Override
                            public java.lang.reflect.Type getOwnerType() {
                                return Class.class;
                            }
                        };
                    }
                };
            }
            lastReadStringPosition = nextSquareBrackets.end();
            nextSquareBrackets = ARRAY_SUFFIX.matcher(type);
            if (nextSquareBrackets.find(lastReadStringPosition) || lastReadStringPosition == len) continue;
            throw new ClassNotFoundException("Unable to make TypeReference from " + type);
        }
        return arrayWrappedType;
    }

    public static abstract class StaticArrayTypeReference<T extends Type>
    extends TypeReference<T> {
        private final int size;

        protected StaticArrayTypeReference(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

