/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.datatypes;

import java.math.BigInteger;
import java.util.Objects;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;

public abstract class NumericType
implements Type<BigInteger> {
    private String type;
    BigInteger value;
    private int bitSize;

    public NumericType(String type, BigInteger value, int bitSize) {
        this.type = type;
        this.value = value;
        this.bitSize = bitSize;
    }

    @Override
    public String getTypeAsString() {
        return this.type;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericType that = (NumericType)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public void setBitSize(int bitSize) {
        this.bitSize = bitSize;
    }
}

