/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.datatypes;

import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.Utils;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;

public class Function {
    private String name;
    private List<Type> inputParameters;
    private List<TypeReference<Type>> outputParameters;
    private int transactionAttribute = 0;

    public Function(String name, List<Type> inputParameters, List<TypeReference<?>> outputParameters) {
        this.name = name;
        this.inputParameters = inputParameters;
        this.outputParameters = Utils.convert(outputParameters);
        this.transactionAttribute = 0;
    }

    public Function(String name, List<Type> inputParameters, List<TypeReference<?>> outputParameters, int transactionAttribute) {
        this.name = name;
        this.inputParameters = inputParameters;
        this.outputParameters = Utils.convert(outputParameters);
        this.transactionAttribute = transactionAttribute;
    }

    public Function() {
        this.name = "";
        this.inputParameters = Collections.emptyList();
        this.outputParameters = Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public List<Type> getInputParameters() {
        return this.inputParameters;
    }

    public List<TypeReference<Type>> getOutputParameters() {
        return this.outputParameters;
    }

    public int getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public void setTransactionAttribute(int transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }
}

