/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.datatypes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.utils.Hex;

public abstract class BytesType
implements Type<byte[]> {
    private byte[] value;
    private String type;

    public BytesType(byte[] src, String type) {
        this.value = src;
        this.type = type;
    }

    @Override
    @JsonSerialize(using=bytesUsingHexSerializer.class)
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesType bytesType = (BytesType)o;
        if (!Arrays.equals(this.value, bytesType.value)) {
            return false;
        }
        return this.type.equals(bytesType.type);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.value);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Override
    public int bytes32PaddedLength() {
        return this.value.length <= 32 ? 32 : (this.value.length / 32 + 1) * 32;
    }

    public static class bytesUsingHexSerializer
    extends JsonSerializer<byte[]> {
        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            String hexString = Hex.toHexString(value);
            gen.writeString(hexString);
        }
    }
}

