/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.abi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.fisco.bcos.sdk.v3.codec.datatypes.Address;
import org.fisco.bcos.sdk.v3.codec.datatypes.Array;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bool;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.BytesType;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.NumericType;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.Ufixed;
import org.fisco.bcos.sdk.v3.codec.datatypes.Uint;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;

public class TypeEncoder {
    private TypeEncoder() {
    }

    public static byte[] encode(Type parameter) {
        if (parameter instanceof NumericType) {
            return TypeEncoder.encodeNumeric((NumericType)parameter);
        }
        if (parameter instanceof Address) {
            return TypeEncoder.encodeAddress((Address)parameter);
        }
        if (parameter instanceof Bool) {
            return TypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return TypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return TypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return TypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof StaticArray) {
            if (DynamicStruct.class.isAssignableFrom(((StaticArray)parameter).getComponentType())) {
                return TypeEncoder.encodeStaticArrayWithDynamicStruct((StaticArray)parameter);
            }
            return TypeEncoder.encodeArrayValues((StaticArray)parameter);
        }
        if (parameter instanceof DynamicStruct) {
            return TypeEncoder.encodeDynamicStruct((DynamicStruct)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return TypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    public static byte[] encodeAddress(Address address) {
        return TypeEncoder.encodeNumeric(address.toUint160());
    }

    public static byte[] encodeNumeric(NumericType numericType) {
        byte[] rawValue = TypeEncoder.toByteArray(numericType);
        byte paddingValue = TypeEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return paddedRawValue;
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    public static byte[] encodeBool(Bool value) {
        byte[] rawValue = new byte[32];
        if (value.getValue().booleanValue()) {
            rawValue[rawValue.length - 1] = 1;
        }
        return rawValue;
    }

    public static byte[] encodeBytes(BytesType bytesType) {
        byte[] dest;
        byte[] value = bytesType.getValue();
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return dest;
    }

    public static byte[] encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        byte[] encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        byte[] encodedValue = TypeEncoder.encodeBytes(dynamicBytes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(encodedLength);
            byteArrayOutputStream.write(encodedValue);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return TypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    public static <T extends Type> byte[] encodeArrayValues(Array<T> value) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            Iterator iterator = value.getValue().iterator();
            while (iterator.hasNext()) {
                Type type = (Type)iterator.next();
                result.write(TypeEncoder.encode(type));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result.toByteArray();
    }

    public static <T extends Type> byte[] encodeDynamicArray(DynamicArray<T> value) {
        int size = value.getValue().size();
        byte[] encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        byte[] valuesOffsets = TypeEncoder.encodeArrayValuesOffsets(value);
        byte[] encodedValues = TypeEncoder.encodeArrayValues(value);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (!value.isFixed()) {
                result.write(encodedLength);
            }
            result.write(valuesOffsets);
            result.write(encodedValues);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result.toByteArray();
    }

    static <T extends Type> byte[] encodeArrayValuesOffsets(DynamicArray<T> value) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        boolean arrayOfBytes = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicBytes;
        boolean arrayOfString = !value.getValue().isEmpty() && value.getValue().get(0) instanceof Utf8String;
        boolean arrayOfDynamicStructs = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicStruct;
        boolean arrayOfDynamicArray = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicArray;
        try {
            if (arrayOfBytes || arrayOfString) {
                long offset = 0L;
                for (int i = 0; i < value.getValue().size(); ++i) {
                    if (i == 0) {
                        offset = value.getValue().size() * 32;
                    } else {
                        int bytesLength = arrayOfBytes ? ((byte[])((Type)value.getValue().get(i - 1)).getValue()).length : ((String)((Type)value.getValue().get(i - 1)).getValue()).length();
                        int numberOfWords = (bytesLength + 32 - 1) / 32;
                        int totalBytesLength = numberOfWords * 32;
                        offset += (long)(totalBytesLength + 32);
                    }
                    result.write(TypeEncoder.toBytesPadded(new BigInteger(Long.toString(offset)), 32));
                }
            } else if (arrayOfDynamicStructs || arrayOfDynamicArray) {
                result.write(TypeEncoder.encodeStructsArraysOffsets(value));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result.toByteArray();
    }

    static <T extends Type> byte[] encodeStructsArraysOffsets(Array<T> value) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        long offset = value.getValue().size();
        List tailsEncoding = value.getValue().stream().map(TypeEncoder::encode).collect(Collectors.toList());
        for (int i = 0; i < value.getValue().size(); ++i) {
            offset = i == 0 ? (offset *= 32L) : (offset += (long)((byte[])tailsEncoding.get(i - 1)).length);
            try {
                result.write(TypeEncoder.toBytesPadded(new BigInteger(Long.toString(offset)), 32));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return result.toByteArray();
    }

    static byte[] toBytesPadded(BigInteger value, int length) {
        int srcOffset;
        int bytesLength;
        byte[] result = new byte[length];
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            bytesLength = bytes.length - 1;
            srcOffset = 1;
        } else {
            bytesLength = bytes.length;
            srcOffset = 0;
        }
        if (bytesLength > length) {
            throw new RuntimeException("Input is too large to put in byte array of size " + length);
        }
        int destOffset = length - bytesLength;
        System.arraycopy(bytes, srcOffset, result, destOffset, bytesLength);
        return result;
    }

    static <T extends Type> byte[] encodeStaticArrayWithDynamicStruct(Array<T> value) {
        byte[] valuesOffsets = TypeEncoder.encodeStructsArraysOffsets(value);
        byte[] encodedValues = TypeEncoder.encodeArrayValues(value);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(valuesOffsets);
            result.write(encodedValues);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result.toByteArray();
    }

    public static byte[] encodeDynamicStruct(DynamicStruct value) {
        byte[] encodedValues = TypeEncoder.encodeDynamicStructValues(value);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(encodedValues);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result.toByteArray();
    }

    private static byte[] encodeDynamicStructValues(DynamicStruct value) {
        int staticSize = 0;
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (TypeEncoder.isDynamic(type)) {
                staticSize += 32;
                continue;
            }
            staticSize += type.bytes32PaddedLength();
        }
        int dynamicOffset = staticSize;
        ArrayList<byte[]> offsetsAndStaticValues = new ArrayList<byte[]>();
        ArrayList<byte[]> dynamicValues = new ArrayList<byte[]>();
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (TypeEncoder.isDynamic(type)) {
                offsetsAndStaticValues.add(TypeEncoder.toBytesPadded(new BigInteger(Long.toString(dynamicOffset)), 32));
                byte[] encodedValue = TypeEncoder.encode(type);
                dynamicValues.add(encodedValue);
                dynamicOffset += encodedValue.length;
                continue;
            }
            offsetsAndStaticValues.add(TypeEncoder.encode((Type)value.getValue().get(i)));
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            for (byte[] offsetsAndStaticValue : offsetsAndStaticValues) {
                result.write(offsetsAndStaticValue);
            }
            for (byte[] dynamicValue : dynamicValues) {
                result.write(dynamicValue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result.toByteArray();
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray || parameter instanceof StaticArray && DynamicStruct.class.isAssignableFrom(((StaticArray)parameter).getComponentType());
    }
}

