/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.abi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.FunctionReturnDecoderInterface;
import org.fisco.bcos.sdk.v3.codec.Utils;
import org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder;
import org.fisco.bcos.sdk.v3.codec.datatypes.Array;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.BytesType;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Bytes32;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.fisco.bcos.sdk.v3.utils.Numeric;
import org.fisco.bcos.sdk.v3.utils.StringUtils;

public class FunctionReturnDecoder
implements FunctionReturnDecoderInterface {
    @Override
    public List<Type> decode(String rawInput, List<TypeReference<Type>> outputParameters) {
        String input = Numeric.cleanHexPrefix(rawInput);
        if (StringUtils.isEmpty(input)) {
            return Collections.emptyList();
        }
        return FunctionReturnDecoder.build(input, outputParameters);
    }

    @Override
    public <T extends Type> Type decodeIndexedValue(String rawInput, TypeReference<T> typeReference) {
        String input = Numeric.cleanHexPrefix(rawInput);
        try {
            Class<T> type = typeReference.getClassType();
            if (Bytes.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(Hex.decode(input), Class.forName(type.getName()));
            }
            if (Array.class.isAssignableFrom(type) || BytesType.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(Hex.decode(input), Bytes32.class);
            }
            return TypeDecoder.decode(Hex.decode(input), 0, typeReference);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static List<Type> build(String input, List<TypeReference<Type>> outputParameters) {
        ArrayList<Type> results = new ArrayList<Type>(outputParameters.size());
        byte[] rawInput = Hex.decode(input);
        int offset = 0;
        for (TypeReference<Type> typeReference : outputParameters) {
            try {
                int length;
                Type result;
                Class<Type> classType = typeReference.getClassType();
                int dataOffset = FunctionReturnDecoder.getDataOffset(rawInput, offset, typeReference);
                if (DynamicStruct.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeDynamicStruct(rawInput, dataOffset, typeReference);
                    offset += 32;
                } else if (DynamicArray.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeDynamicArray(rawInput, dataOffset, typeReference);
                    offset += 32;
                } else if (typeReference instanceof TypeReference.StaticArrayTypeReference) {
                    length = ((TypeReference.StaticArrayTypeReference)typeReference).getSize();
                    result = TypeDecoder.decodeStaticArray(rawInput, dataOffset, typeReference, length);
                    offset += length * 32;
                } else if (StaticStruct.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeStaticStruct(rawInput, dataOffset, typeReference);
                    offset += Utils.staticStructNestedPublicFieldsFlatList(classType).size() * 32;
                } else if (StaticArray.class.isAssignableFrom(classType)) {
                    length = Integer.parseInt(classType.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                    result = TypeDecoder.decodeStaticArray(rawInput, dataOffset, typeReference, length);
                    offset = DynamicStruct.class.isAssignableFrom(Utils.getParameterizedTypeFromArray(typeReference)) ? (offset += 32) : (StaticStruct.class.isAssignableFrom(Utils.getParameterizedTypeFromArray(typeReference)) ? (offset += Utils.staticStructNestedPublicFieldsFlatList(Utils.getParameterizedTypeFromArray(typeReference)).size() * length * 32) : (offset += 32 * length));
                } else {
                    result = TypeDecoder.decode(rawInput, dataOffset, typeReference);
                    offset += 32;
                }
                results.add(result);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Invalid class reference provided", e);
            }
        }
        return results;
    }

    public static <T extends Type> int getDataOffset(byte[] input, int offset, TypeReference<?> typeReference) throws ClassNotFoundException {
        Class<?> type = typeReference.getClassType();
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type) || DynamicArray.class.isAssignableFrom(type) || FunctionReturnDecoder.hasDynamicOffsetInStaticArray(typeReference, offset)) {
            return TypeDecoder.decodeUintAsInt(input, offset);
        }
        return offset;
    }

    private static boolean hasDynamicOffsetInStaticArray(TypeReference<?> typeReference, int offset) throws ClassNotFoundException {
        Class<?> type = typeReference.getClassType();
        try {
            return StaticArray.class.isAssignableFrom(type) && (DynamicStruct.class.isAssignableFrom(Utils.getParameterizedTypeFromArray(typeReference)) || TypeDecoder.isDynamic(Utils.getParameterizedTypeFromArray(typeReference)));
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

